/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.Registry;
import org.miaixz.bus.mapper.parsing.KeySqlSource;
import org.miaixz.bus.mapper.parsing.SqlMetaCache;
import org.miaixz.bus.mapper.parsing.TableMeta;

public class Caching
extends XMLLanguageDriver {
    private static final Map<String, SqlMetaCache> CACHE_SQL = new ConcurrentHashMap<String, SqlMetaCache>(Keys.getInt((String)"bus.mybatis.provider.initSize", (int)1024));
    private static final Map<Configuration, Map<String, SqlSource>> CONFIGURATION_CACHE_KEY_MAP = new ConcurrentHashMap<Configuration, Map<String, SqlSource>>(4);
    private static final boolean USE_ONCE = Keys.getBoolean((String)"bus.mybatis.provider.useOnce", (boolean)false);

    private static String cacheKey(ProviderContext providerContext) {
        return (providerContext.getMapperType().getName() + "." + providerContext.getMapperMethod().getName()).intern();
    }

    private static void isAnnotationPresentLang(ProviderContext providerContext) {
        Lang lang;
        Method mapperMethod = providerContext.getMapperMethod();
        if (mapperMethod.isAnnotationPresent(Lang.class) && (lang = mapperMethod.getAnnotation(Lang.class)).value() == Caching.class) {
            return;
        }
        throw new RuntimeException(String.valueOf(mapperMethod) + " need to configure @Lang(Caching.class) to use the Caching.cache method for caching");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cache(ProviderContext providerContext, TableMeta entity, Supplier<String> sqlScriptSupplier) {
        String cacheKey = Caching.cacheKey(providerContext);
        if (!CACHE_SQL.containsKey(cacheKey)) {
            Caching.isAnnotationPresentLang(providerContext);
            String string = cacheKey;
            synchronized (string) {
                if (!CACHE_SQL.containsKey(cacheKey)) {
                    CACHE_SQL.put(cacheKey, new SqlMetaCache(Objects.requireNonNull(providerContext), Objects.requireNonNull(entity), Objects.requireNonNull(sqlScriptSupplier)));
                }
            }
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        if (CACHE_SQL.containsKey(script)) {
            String cacheKey = script;
            if (!CONFIGURATION_CACHE_KEY_MAP.containsKey(configuration) || !CONFIGURATION_CACHE_KEY_MAP.get(configuration).containsKey(cacheKey)) {
                String string = cacheKey;
                synchronized (string) {
                    if (!CONFIGURATION_CACHE_KEY_MAP.containsKey(configuration) || !CONFIGURATION_CACHE_KEY_MAP.get(configuration).containsKey(cacheKey)) {
                        SqlMetaCache cache = CACHE_SQL.get(cacheKey);
                        if (cache == SqlMetaCache.NULL) {
                            throw new RuntimeException(script + " => CACHE_SQL is NULL, you need to configure mybatis.provider.cacheSql.useOnce=false");
                        }
                        cache.getEntity().initRuntimeContext(configuration, cache.getProviderContext(), cacheKey);
                        Map cachekeyMap = CONFIGURATION_CACHE_KEY_MAP.computeIfAbsent(configuration, k -> new ConcurrentHashMap());
                        MappedStatement ms = configuration.getMappedStatement(cacheKey);
                        Registry.SPI.customize(cache.getEntity(), ms, cache.getProviderContext());
                        String sqlScript = cache.getSqlScript();
                        if (Logger.isTraceEnabled()) {
                            Logger.trace((String)("cacheKey - " + cacheKey + " :\n" + sqlScript + "\n"), (Object[])new Object[0]);
                        }
                        SqlSource sqlSource = super.createSqlSource(configuration, sqlScript, parameterType);
                        sqlSource = KeySqlSource.SPI.customize(sqlSource, cache.getEntity(), ms, cache.getProviderContext());
                        cachekeyMap.put(cacheKey, sqlSource);
                        if (USE_ONCE) {
                            CACHE_SQL.put(cacheKey, SqlMetaCache.NULL);
                        }
                    }
                }
            }
            return CONFIGURATION_CACHE_KEY_MAP.get(configuration).get(cacheKey);
        }
        return super.createSqlSource(configuration, script, parameterType);
    }
}

