/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper;

import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import org.miaixz.bus.core.lang.loader.spi.NormalSpiLoader;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.Args;
import org.miaixz.bus.mapper.ORDER;
import org.miaixz.bus.mapper.binding.function.Fn;
import org.miaixz.bus.mapper.support.ClassColumn;
import org.miaixz.bus.mapper.support.ClassField;

public class OGNL {
    public static void registerSimpleType(Class<?> clazz) {
        Args.SIMPLE_TYPE_SET.add(clazz);
    }

    public static void registerSimpleType(String classes) {
        if (StringKit.isNotEmpty((CharSequence)classes)) {
            String[] cls;
            for (String c : cls = classes.split(",")) {
                try {
                    Args.SIMPLE_TYPE_SET.add(Class.forName(c));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Failed to register type: " + c, e);
                }
            }
        }
    }

    public static void registerSimpleTypeSilence(String clazz) {
        try {
            Args.SIMPLE_TYPE_SET.add(Class.forName(clazz));
        }
        catch (ClassNotFoundException e) {
            Logger.debug((String)("Class not found, ignored: " + clazz), (Object[])new Object[0]);
        }
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return Args.SIMPLE_TYPE_SET.contains(clazz);
    }

    public static <T> List<T> getInstances(Class<T> clazz) {
        List list = NormalSpiLoader.loadList((boolean)false, clazz);
        if (list.size() > 1 && ORDER.class.isAssignableFrom(clazz)) {
            list.sort(Comparator.comparing(f -> ((ORDER)f).order()).reversed());
        }
        return list;
    }

    public static ClassField fnToFieldName(Fn<?, ?> fn) {
        try {
            Class<?> clazz = null;
            if (fn instanceof Fn.FnName) {
                Fn.FnName field = (Fn.FnName)fn;
                if (field.column) {
                    return new ClassColumn(field.entityClass, field.name);
                }
                return new ClassField(field.entityClass, field.name);
            }
            if (fn instanceof Fn.FnType) {
                clazz = ((Fn.FnType)fn).entityClass;
                fn = ((Fn.FnType)fn).fn;
                while (fn instanceof Fn.FnType) {
                    fn = ((Fn.FnType)fn).fn;
                }
            }
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(fn, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            if (Args.GET_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(3);
            } else if (Args.IS_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(2);
            }
            String field = Introspector.decapitalize(getter);
            if (clazz == null) {
                Matcher matcher = Args.INSTANTIATED_CLASS_PATTERN.matcher(serializedLambda.getInstantiatedMethodType());
                String implClass = matcher.find() ? matcher.group("cls").replaceAll("/", "\\.") : serializedLambda.getImplClass().replaceAll("/", "\\.");
                clazz = Class.forName(implClass);
            }
            return new ClassField(clazz, field);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to convert Fn to field name", e);
        }
    }
}

