/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.binding.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import org.miaixz.bus.mapper.Args;
import org.miaixz.bus.mapper.binding.function.Fn;
import org.miaixz.bus.mapper.criteria.Criteria;
import org.miaixz.bus.mapper.criteria.Criterion;
import org.miaixz.bus.mapper.criteria.OrCriteria;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.TableMeta;

public class Condition<T> {
    protected String orderByClause;
    protected boolean distinct;
    protected String selectColumns;
    protected String simpleSelectColumns;
    protected String startSql;
    protected String endSql;
    protected List<Criteria<T>> oredCriteria;
    protected List<Criterion> setValues;

    public Condition() {
        this.oredCriteria = new ArrayList<Criteria<T>>();
        this.setValues = new ArrayList<Criterion>();
    }

    public void or(Criteria<T> criteria) {
        this.oredCriteria.add(criteria);
    }

    public Criteria<T> or() {
        Criteria<T> criteria = this.createCriteriaInternal();
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public OrCriteria<T> orPart() {
        return new OrCriteria();
    }

    public Criteria<T> createCriteria() {
        Criteria<T> criteria = this.createCriteriaInternal();
        if (this.oredCriteria.isEmpty()) {
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    public Criteria<T> createCriteriaSelective() {
        Criteria criteria = new Criteria(true);
        if (this.oredCriteria.isEmpty()) {
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria<T> createCriteriaInternal() {
        return new Criteria();
    }

    public void clear() {
        this.oredCriteria.clear();
        this.setValues.clear();
        this.orderByClause = null;
        this.distinct = false;
        this.selectColumns = null;
        this.simpleSelectColumns = null;
        this.startSql = null;
        this.endSql = null;
    }

    @SafeVarargs
    public final Condition<T> selectColumns(Fn<T, Object> ... fns) {
        this.selectColumns = "";
        this.simpleSelectColumns = "";
        if (fns == null || fns.length == 0) {
            return this;
        }
        this.selectColumns(Arrays.stream(fns).map(Fn::toEntityColumn).collect(Collectors.toList()));
        return this;
    }

    private void selectColumns(List<ColumnMeta> columns) {
        StringBuilder sb = new StringBuilder(columns.size() * 16);
        StringBuilder simple = new StringBuilder(columns.size() * 16);
        for (ColumnMeta entityColumn : columns) {
            String column = entityColumn.column();
            String field = entityColumn.field().getName();
            if (sb.length() != 0) {
                sb.append(",");
                simple.append(",");
            }
            if (column.equals(field) || entityColumn.entityTable().useResultMaps()) {
                sb.append(column);
                simple.append(column);
                continue;
            }
            Matcher matcher = Args.DELIMITER.matcher(column);
            simple.append(column);
            if (matcher.find() && field.equals(matcher.group(1))) {
                sb.append(column);
                continue;
            }
            sb.append(column).append(" AS ").append(field);
        }
        this.selectColumns = sb.toString();
        this.simpleSelectColumns = simple.toString();
    }

    @SafeVarargs
    public final Condition<T> excludeColumns(Fn<T, Object> ... fns) {
        this.selectColumns = "";
        this.simpleSelectColumns = "";
        if (fns == null || fns.length == 0) {
            return this;
        }
        TableMeta table = fns[0].toEntityColumn().entityTable();
        Set excludeColumnSet = Arrays.stream(fns).map(Fn::toColumn).collect(Collectors.toSet());
        this.selectColumns(table.selectColumns().stream().filter(c -> !excludeColumnSet.contains(c.column())).collect(Collectors.toList()));
        return this;
    }

    public String getSelectColumns() {
        return this.selectColumns;
    }

    public Condition<T> setSelectColumns(String selectColumns) {
        this.selectColumns = selectColumns;
        return this;
    }

    public String getSimpleSelectColumns() {
        return this.simpleSelectColumns;
    }

    public Condition<T> setSimpleSelectColumns(String simpleSelectColumns) {
        this.simpleSelectColumns = simpleSelectColumns;
        return this;
    }

    public String getStartSql() {
        return this.startSql;
    }

    public Condition<T> setStartSql(String startSql) {
        this.startSql = startSql;
        return this;
    }

    public String getEndSql() {
        return this.endSql;
    }

    public Condition<T> setEndSql(String endSql) {
        this.endSql = endSql;
        return this;
    }

    public Condition<T> orderBy(Fn<T, Object> fn, String order) {
        this.orderByClause = this.orderByClause == null ? "" : this.orderByClause + ", ";
        this.orderByClause = this.orderByClause + fn.toColumn() + " " + order;
        return this;
    }

    public Condition<T> orderBy(String orderByCondition) {
        if (orderByCondition != null && !orderByCondition.isEmpty()) {
            this.orderByClause = this.orderByClause == null ? "" : this.orderByClause + ", ";
            this.orderByClause = this.orderByClause + orderByCondition;
        }
        return this;
    }

    public Condition<T> orderBy(Supplier<String> orderByCondition) {
        return this.orderBy(orderByCondition.get());
    }

    @SafeVarargs
    public final Condition<T> orderByAsc(Fn<T, Object> ... fns) {
        if (fns != null && fns.length > 0) {
            for (Fn<T, Object> fn : fns) {
                this.orderBy(fn, "ASC");
            }
        }
        return this;
    }

    @SafeVarargs
    public final Condition<T> orderByDesc(Fn<T, Object> ... fns) {
        if (fns != null && fns.length > 0) {
            for (Fn<T, Object> fn : fns) {
                this.orderBy(fn, "DESC");
            }
        }
        return this;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public Condition<T> setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    public List<Criteria<T>> getOredCriteria() {
        return this.oredCriteria;
    }

    public List<Criterion> getSetValues() {
        return this.setValues;
    }

    public boolean isEmpty() {
        if (this.oredCriteria.isEmpty()) {
            return true;
        }
        return this.oredCriteria.stream().allMatch(criteria -> criteria.getCriteria().isEmpty());
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Condition<T> setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public Condition<T> set(String setSql) {
        this.setValues.add(new Criterion(setSql));
        return this;
    }

    public Condition<T> set(Fn<T, Object> fn, Object value) {
        ColumnMeta column = fn.toEntityColumn();
        this.setValues.add(new Criterion(column.column(), value, column));
        return this;
    }

    @Generated
    protected Condition(ConditionBuilder<T, ?, ?> b) {
        this.orderByClause = b.orderByClause;
        this.distinct = b.distinct;
        this.selectColumns = b.selectColumns;
        this.simpleSelectColumns = b.simpleSelectColumns;
        this.startSql = b.startSql;
        this.endSql = b.endSql;
        this.oredCriteria = b.oredCriteria;
        this.setValues = b.setValues;
    }

    @Generated
    public static <T> ConditionBuilder<T, ?, ?> builder() {
        return new ConditionBuilderImpl();
    }

    @Generated
    public void setOredCriteria(List<Criteria<T>> oredCriteria) {
        this.oredCriteria = oredCriteria;
    }

    @Generated
    public void setSetValues(List<Criterion> setValues) {
        this.setValues = setValues;
    }

    @Generated
    public static abstract class ConditionBuilder<T, C extends Condition<T>, B extends ConditionBuilder<T, C, B>> {
        @Generated
        private String orderByClause;
        @Generated
        private boolean distinct;
        @Generated
        private String selectColumns;
        @Generated
        private String simpleSelectColumns;
        @Generated
        private String startSql;
        @Generated
        private String endSql;
        @Generated
        private List<Criteria<T>> oredCriteria;
        @Generated
        private List<Criterion> setValues;

        @Generated
        public B orderByClause(String orderByClause) {
            this.orderByClause = orderByClause;
            return this.self();
        }

        @Generated
        public B distinct(boolean distinct) {
            this.distinct = distinct;
            return this.self();
        }

        @Generated
        public B selectColumns(String selectColumns) {
            this.selectColumns = selectColumns;
            return this.self();
        }

        @Generated
        public B simpleSelectColumns(String simpleSelectColumns) {
            this.simpleSelectColumns = simpleSelectColumns;
            return this.self();
        }

        @Generated
        public B startSql(String startSql) {
            this.startSql = startSql;
            return this.self();
        }

        @Generated
        public B endSql(String endSql) {
            this.endSql = endSql;
            return this.self();
        }

        @Generated
        public B oredCriteria(List<Criteria<T>> oredCriteria) {
            this.oredCriteria = oredCriteria;
            return this.self();
        }

        @Generated
        public B setValues(List<Criterion> setValues) {
            this.setValues = setValues;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Condition.ConditionBuilder(orderByClause=" + this.orderByClause + ", distinct=" + this.distinct + ", selectColumns=" + this.selectColumns + ", simpleSelectColumns=" + this.simpleSelectColumns + ", startSql=" + this.startSql + ", endSql=" + this.endSql + ", oredCriteria=" + String.valueOf(this.oredCriteria) + ", setValues=" + String.valueOf(this.setValues) + ")";
        }
    }

    @Generated
    private static final class ConditionBuilderImpl<T>
    extends ConditionBuilder<T, Condition<T>, ConditionBuilderImpl<T>> {
        @Generated
        private ConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected ConditionBuilderImpl<T> self() {
            return this;
        }

        @Override
        @Generated
        public Condition<T> build() {
            return new Condition(this);
        }
    }
}

