/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.binding.condition;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.session.RowBounds;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.mapper.binding.BasicMapper;
import org.miaixz.bus.mapper.binding.condition.Condition;
import org.miaixz.bus.mapper.binding.function.Fn;
import org.miaixz.bus.mapper.criteria.Criteria;
import org.miaixz.bus.mapper.criteria.OrCriteria;

public class ConditionWrapper<T, I extends Serializable> {
    private final BasicMapper<T, I> basicMapper;
    private final Condition<T> condition;
    private Criteria<T> current;

    public ConditionWrapper(BasicMapper<T, I> basicMapper, Condition<T> condition) {
        this.basicMapper = basicMapper;
        this.condition = condition;
        this.current = condition.createCriteria();
    }

    public ConditionWrapper<T, I> or() {
        this.current = this.condition.or();
        return this;
    }

    public Condition<T> condition() {
        return this.condition;
    }

    public ConditionWrapper<T, I> clear() {
        this.condition.clear();
        this.current = this.condition.createCriteria();
        return this;
    }

    @SafeVarargs
    public final ConditionWrapper<T, I> select(Fn<T, Object> ... fns) {
        this.condition.selectColumns(fns);
        return this;
    }

    @SafeVarargs
    public final ConditionWrapper<T, I> exclude(Fn<T, Object> ... fns) {
        this.condition.excludeColumns(fns);
        return this;
    }

    public ConditionWrapper<T, I> startSql(String startSql) {
        this.condition.setStartSql(startSql);
        return this;
    }

    public ConditionWrapper<T, I> endSql(String endSql) {
        this.condition.setEndSql(endSql);
        return this;
    }

    public ConditionWrapper<T, I> orderBy(Fn<T, Object> fn, String order) {
        this.condition.orderBy(fn, order);
        return this;
    }

    public ConditionWrapper<T, I> orderBy(String orderByCondition) {
        this.condition.orderBy(orderByCondition);
        return this;
    }

    public ConditionWrapper<T, I> orderBy(Supplier<String> orderByCondition) {
        this.condition.orderBy(orderByCondition);
        return this;
    }

    public ConditionWrapper<T, I> orderBy(boolean useOrderBy, Supplier<String> orderByCondition) {
        return useOrderBy ? this.orderBy(orderByCondition) : this;
    }

    @SafeVarargs
    public final ConditionWrapper<T, I> orderByAsc(Fn<T, Object> ... fns) {
        this.condition.orderByAsc(fns);
        return this;
    }

    @SafeVarargs
    public final ConditionWrapper<T, I> orderByDesc(Fn<T, Object> ... fns) {
        this.condition.orderByDesc(fns);
        return this;
    }

    public ConditionWrapper<T, I> distinct() {
        this.condition.setDistinct(true);
        return this;
    }

    public ConditionWrapper<T, I> set(boolean useSet, String setSql) {
        return useSet ? this.set(setSql) : this;
    }

    public ConditionWrapper<T, I> set(String setSql) {
        this.condition.set(setSql);
        return this;
    }

    public ConditionWrapper<T, I> set(boolean useSet, Fn<T, Object> fn, Object value) {
        return useSet ? this.set(fn, value) : this;
    }

    public ConditionWrapper<T, I> set(boolean useSet, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useSet ? this.set(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> set(Fn<T, Object> fn, Object value) {
        this.condition.set(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> isNull(boolean useCondition, Fn<T, Object> fn) {
        return useCondition ? this.isNull(fn) : this;
    }

    public ConditionWrapper<T, I> isNull(Fn<T, Object> fn) {
        this.current.andIsNull(fn);
        return this;
    }

    public ConditionWrapper<T, I> isNotNull(boolean useCondition, Fn<T, Object> fn) {
        return useCondition ? this.isNotNull(fn) : this;
    }

    public ConditionWrapper<T, I> isNotNull(Fn<T, Object> fn) {
        this.current.andIsNotNull(fn);
        return this;
    }

    public ConditionWrapper<T, I> eq(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.eq(fn, value) : this;
    }

    public ConditionWrapper<T, I> eq(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.eq(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> eq(Fn<T, Object> fn, Object value) {
        this.current.andEqualTo(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> ne(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.ne(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> ne(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.ne(fn, value) : this;
    }

    public ConditionWrapper<T, I> ne(Fn<T, Object> fn, Object value) {
        this.current.andNotEqualTo(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> gt(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.gt(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> gt(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.gt(fn, value) : this;
    }

    public ConditionWrapper<T, I> gt(Fn<T, Object> fn, Object value) {
        this.current.andGreaterThan(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> ge(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.ge(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> ge(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.ge(fn, value) : this;
    }

    public ConditionWrapper<T, I> ge(Fn<T, Object> fn, Object value) {
        this.current.andGreaterThanOrEqualTo(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> lt(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.lt(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> lt(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.lt(fn, value) : this;
    }

    public ConditionWrapper<T, I> lt(Fn<T, Object> fn, Object value) {
        this.current.andLessThan(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> le(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.le(fn, value) : this;
    }

    public ConditionWrapper<T, I> le(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.le(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> le(Fn<T, Object> fn, Object value) {
        this.current.andLessThanOrEqualTo(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> in(boolean useCondition, Fn<T, Object> fn, Iterable<?> values) {
        return useCondition ? this.in(fn, values) : this;
    }

    public ConditionWrapper<T, I> in(boolean useCondition, Fn<T, Object> fn, Supplier<Iterable<?>> supplier) {
        return useCondition ? this.in(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> in(Fn<T, Object> fn, Iterable<?> values) {
        this.current.andIn(fn, values);
        return this;
    }

    public ConditionWrapper<T, I> notIn(boolean useCondition, Fn<T, Object> fn, Iterable<?> values) {
        return useCondition ? this.notIn(fn, values) : this;
    }

    public ConditionWrapper<T, I> notIn(boolean useCondition, Fn<T, Object> fn, Supplier<Iterable<?>> supplier) {
        return useCondition ? this.notIn(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> notIn(Fn<T, Object> fn, Iterable<?> values) {
        this.current.andNotIn(fn, values);
        return this;
    }

    public ConditionWrapper<T, I> between(boolean useCondition, Fn<T, Object> fn, Object value1, Object value2) {
        return useCondition ? this.between(fn, value1, value2) : this;
    }

    public ConditionWrapper<T, I> between(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier1, Supplier<Object> supplier2) {
        return useCondition ? this.between(fn, supplier1.get(), supplier2.get()) : this;
    }

    public ConditionWrapper<T, I> between(Fn<T, Object> fn, Object value1, Object value2) {
        this.current.andBetween(fn, value1, value2);
        return this;
    }

    public ConditionWrapper<T, I> notBetween(boolean useCondition, Fn<T, Object> fn, Object value1, Object value2) {
        return useCondition ? this.notBetween(fn, value1, value2) : this;
    }

    public ConditionWrapper<T, I> notBetween(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier1, Supplier<Object> supplier2) {
        return useCondition ? this.notBetween(fn, supplier1.get(), supplier2.get()) : this;
    }

    public ConditionWrapper<T, I> notBetween(Fn<T, Object> fn, Object value1, Object value2) {
        this.current.andNotBetween(fn, value1, value2);
        return this;
    }

    public ConditionWrapper<T, I> contains(boolean useCondition, Fn<T, Object> fn, String value) {
        return useCondition ? this.contains(fn, value) : this;
    }

    public ConditionWrapper<T, I> contains(boolean useCondition, Fn<T, Object> fn, Supplier<String> supplier) {
        return useCondition ? this.contains(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> contains(Fn<T, Object> fn, String value) {
        this.current.addCriterion(fn.toColumn() + " LIKE", "%" + value + "%");
        return this;
    }

    public ConditionWrapper<T, I> startsWith(boolean useCondition, Fn<T, Object> fn, String value) {
        return useCondition ? this.startsWith(fn, value) : this;
    }

    public ConditionWrapper<T, I> startsWith(boolean useCondition, Fn<T, Object> fn, Supplier<String> supplier) {
        return useCondition ? this.startsWith(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> startsWith(Fn<T, Object> fn, String value) {
        this.current.addCriterion(fn.toColumn() + " LIKE", value + "%");
        return this;
    }

    public ConditionWrapper<T, I> endsWith(boolean useCondition, Fn<T, Object> fn, String value) {
        return useCondition ? this.endsWith(fn, value) : this;
    }

    public ConditionWrapper<T, I> endsWith(boolean useCondition, Fn<T, Object> fn, Supplier<String> supplier) {
        return useCondition ? this.endsWith(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> endsWith(Fn<T, Object> fn, String value) {
        this.current.addCriterion(fn.toColumn() + " LIKE", "%" + value);
        return this;
    }

    public ConditionWrapper<T, I> like(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.like(fn, value) : this;
    }

    public ConditionWrapper<T, I> like(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.like(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> like(Fn<T, Object> fn, Object value) {
        this.current.andLike(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> notLike(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.notLike(fn, value) : this;
    }

    public ConditionWrapper<T, I> notLike(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.notLike(fn, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> notLike(Fn<T, Object> fn, Object value) {
        this.current.andNotLike(fn, value);
        return this;
    }

    public ConditionWrapper<T, I> anyCondition(boolean useCondition, String condition) {
        return useCondition ? this.anyCondition(condition) : this;
    }

    public ConditionWrapper<T, I> anyCondition(String condition) {
        this.current.andCondition(condition);
        return this;
    }

    public ConditionWrapper<T, I> anyCondition(boolean useCondition, String condition, Object value) {
        return useCondition ? this.anyCondition(condition, value) : this;
    }

    public ConditionWrapper<T, I> anyCondition(boolean useCondition, String condition, Supplier<Object> supplier) {
        return useCondition ? this.anyCondition(condition, supplier.get()) : this;
    }

    public ConditionWrapper<T, I> anyCondition(String condition, Object value) {
        this.current.andCondition(condition, value);
        return this;
    }

    @SafeVarargs
    public final ConditionWrapper<T, I> or(Function<OrCriteria<T>, OrCriteria<T>> ... orParts) {
        if (orParts != null && orParts.length > 0) {
            this.current.andOr(Arrays.stream(orParts).map(orPart -> (OrCriteria)orPart.apply(this.condition.orPart())).collect(Collectors.toList()));
        }
        return this;
    }

    public int delete() {
        return this.basicMapper.deleteByCondition(this.condition);
    }

    public int update() {
        Assert.notEmpty(this.condition.getSetValues(), (String)"\u5fc5\u987b\u901a\u8fc7 set \u65b9\u6cd5\u8bbe\u7f6e\u66f4\u65b0\u7684\u5217\u548c\u503c", (Object[])new Object[0]);
        return this.basicMapper.updateByConditionSetValues(this.condition);
    }

    public int update(T t) {
        return this.basicMapper.updateByCondition(t, this.condition);
    }

    public int updateSelective(T t) {
        return this.basicMapper.updateByConditionSelective(t, this.condition);
    }

    public List<T> list() {
        return this.basicMapper.selectByCondition(this.condition);
    }

    public List<T> page(int pageNum, int pageSize) {
        return this.basicMapper.selectByCondition(this.condition, new RowBounds((pageNum - 1) * pageSize, pageSize));
    }

    public List<T> offset(int offset, int limit) {
        return this.basicMapper.selectByCondition(this.condition, new RowBounds(offset, limit));
    }

    public Cursor<T> cursor() {
        return this.basicMapper.selectCursorByCondition(this.condition);
    }

    public Stream<T> stream() {
        return this.list().stream();
    }

    public Optional<T> one() {
        return this.basicMapper.selectOneByCondition(this.condition);
    }

    public Optional<T> first() {
        List result = this.basicMapper.selectByCondition(this.condition, new RowBounds(0, 1));
        return result.isEmpty() ? Optional.empty() : Optional.of(result.get(0));
    }

    public List<T> top(int n) {
        return this.basicMapper.selectByCondition(this.condition, new RowBounds(0, n));
    }

    public long count() {
        return this.basicMapper.countByCondition(this.condition);
    }
}

