/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.mapper.builder.TableSchemaBuilder;
import org.miaixz.bus.mapper.parsing.TableMeta;

public class CachingTableSchemaBuilder
implements TableSchemaBuilder {
    private final Map<Class<?>, TableMeta> ENTITY_CLASS_MAP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableMeta createEntityTable(Class<?> entityClass, TableSchemaBuilder.Chain chain) {
        if (this.ENTITY_CLASS_MAP.get(entityClass) == null) {
            Class<?> clazz = entityClass;
            synchronized (clazz) {
                if (this.ENTITY_CLASS_MAP.get(entityClass) == null) {
                    TableMeta entityTable = chain.createEntityTable(entityClass);
                    if (entityTable != null) {
                        this.ENTITY_CLASS_MAP.put(entityClass, entityTable);
                    } else {
                        return null;
                    }
                }
            }
        }
        return this.ENTITY_CLASS_MAP.get(entityClass);
    }

    public int order() {
        return Integer.MAX_VALUE;
    }
}

