/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.loader.spi.NormalSpiLoader;
import org.miaixz.bus.mapper.ORDER;

public interface ClassMetaResolver
extends ORDER {
    public static final Map<MapperTypeMethod, Optional<Class<?>>> ENTITY_CLASS_MAP = new ConcurrentHashMap();

    public static Optional<Class<?>> find(Class<?> mapperType, Method mapperMethod) {
        Objects.requireNonNull(mapperType);
        return ENTITY_CLASS_MAP.computeIfAbsent(new MapperTypeMethod(mapperType, mapperMethod), mapperTypeMethod -> {
            for (ClassMetaResolver instance : EntityClassFinderInstance.getInstances()) {
                Optional<Class<?>> optionalClass = instance.findEntityClass(mapperType, mapperMethod);
                if (!optionalClass.isPresent()) continue;
                return optionalClass;
            }
            return Optional.empty();
        });
    }

    public Optional<Class<?>> findEntityClass(Class<?> var1, Method var2);

    public boolean isEntityClass(Class<?> var1);

    public static class MapperTypeMethod {
        private final Class<?> mapperType;
        private final Method mapperMethod;

        public MapperTypeMethod(Class<?> mapperType, Method mapperMethod) {
            this.mapperType = mapperType;
            this.mapperMethod = mapperMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapperTypeMethod that = (MapperTypeMethod)o;
            return Objects.equals(this.mapperType, that.mapperType) && Objects.equals(this.mapperMethod, that.mapperMethod);
        }

        public int hashCode() {
            return Objects.hash(this.mapperType, this.mapperMethod);
        }

        public String toString() {
            return (String)(this.mapperType != null ? this.mapperType.getSimpleName() + "." : "") + (this.mapperMethod != null ? this.mapperMethod.getName() : "");
        }
    }

    public static class EntityClassFinderInstance {
        private static volatile List<ClassMetaResolver> INSTANCES;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static List<ClassMetaResolver> getInstances() {
            if (INSTANCES != null) return INSTANCES;
            Class<ClassMetaResolver> clazz = ClassMetaResolver.class;
            synchronized (ClassMetaResolver.class) {
                if (INSTANCES != null) return INSTANCES;
                INSTANCES = NormalSpiLoader.loadList((boolean)false, ClassMetaResolver.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCES;
            }
        }
    }
}

