/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Id;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Transient;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.type.TypeHandler;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.mapper.builder.ColumnSchemaBuilder;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.FieldMeta;
import org.miaixz.bus.mapper.parsing.TableMeta;
import org.miaixz.bus.mapper.provider.NamingProvider;

public class ColumnAnnotationBuilder
implements ColumnSchemaBuilder {
    @Override
    public Optional<List<ColumnMeta>> createEntityColumn(TableMeta entityTable, FieldMeta field, ColumnSchemaBuilder.Chain chain) {
        Optional columns = chain.createEntityColumn(entityTable, field);
        if (columns == IGNORE || field.isAnnotationPresent(Transient.class)) {
            return IGNORE;
        }
        if (!columns.isPresent()) {
            columns = Optional.of(Collections.singletonList(ColumnMeta.of(field).column(NamingProvider.getDefaultStyle().columnName(entityTable, field))));
        }
        if (columns.isPresent()) {
            List list = (List)columns.getOrNull();
            for (ColumnMeta columnMeta : list) {
                Convert convert;
                Class converter;
                FieldMeta entityField = columnMeta.field();
                if (!columnMeta.id()) {
                    columnMeta.id(entityField.isAnnotationPresent(Id.class));
                }
                if (field.isAnnotationPresent(Column.class)) {
                    Column column = field.getAnnotation(Column.class);
                    String columnName = column.name();
                    if (!columnName.isEmpty()) {
                        columnMeta.column(columnName);
                    }
                    columnMeta.insertable(column.insertable()).updatable(column.updatable());
                    if (column.scale() != 0) {
                        columnMeta.numericScale(String.valueOf(column.scale()));
                    }
                }
                if (field.isAnnotationPresent(OrderBy.class)) {
                    OrderBy orderBy = field.getAnnotation(OrderBy.class);
                    if (orderBy.value().isEmpty()) {
                        columnMeta.orderBy("ASC");
                    } else {
                        columnMeta.orderBy(orderBy.value());
                    }
                }
                if (!field.isAnnotationPresent(Convert.class) || (converter = (convert = field.getAnnotation(Convert.class)).converter()) == Void.TYPE || !TypeHandler.class.isAssignableFrom(converter)) continue;
                columnMeta.typeHandler(converter);
            }
        }
        return columns;
    }
}

