/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.builder.TableSchemaBuilder;
import org.miaixz.bus.mapper.parsing.TableMeta;
import org.miaixz.bus.mapper.provider.NamingProvider;

public class TableAnnotationBuilder
implements TableSchemaBuilder {
    @Override
    public TableMeta createEntityTable(Class<?> entityClass, TableSchemaBuilder.Chain chain) {
        TableMeta entityTable = chain.createEntityTable(entityClass);
        if (entityTable == null) {
            entityTable = TableMeta.of(entityClass);
        }
        if (entityClass.isAnnotationPresent(Table.class)) {
            Table table = entityClass.getAnnotation(Table.class);
            if (!table.name().isEmpty()) {
                entityTable.table(table.name());
            }
            if (!table.catalog().isEmpty()) {
                entityTable.catalog(table.catalog());
            }
            if (!table.schema().isEmpty()) {
                entityTable.schema(table.schema());
            }
        } else if (StringKit.isEmpty((CharSequence)entityTable.table())) {
            entityTable.table(NamingProvider.getDefaultStyle().tableName(entityClass));
        }
        if (entityClass.isAnnotationPresent(Entity.class)) {
            entityTable.autoResultMap(true);
        }
        return entityTable;
    }
}

