/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.miaixz.bus.core.lang.Keys;

public class ConfigMeta<T extends ConfigMeta> {
    protected Map<String, String> props;

    public String getProp(String prop) {
        String val;
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        String string = val = this.props != null ? this.props.get(prop) : null;
        if (val == null) {
            val = Keys.get((String)prop);
        }
        return val;
    }

    public String getProp(String prop, String defaultValue) {
        String val = this.getProp(prop);
        return val != null ? val : defaultValue;
    }

    public Integer getPropInt(String prop) {
        String val = this.getProp(prop);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return null;
    }

    public Integer getPropInt(String prop, Integer defaultValue) {
        Integer val = this.getPropInt(prop);
        return val != null ? val : defaultValue;
    }

    public Boolean getPropBoolean(String prop) {
        String val = this.getProp(prop);
        return Boolean.parseBoolean(val);
    }

    public Boolean getPropBoolean(String prop, Boolean defaultValue) {
        String val = this.getProp(prop);
        return val != null ? Boolean.parseBoolean(val) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T setProp(String prop, String value) {
        if (this.props == null) {
            ConfigMeta configMeta = this;
            synchronized (configMeta) {
                if (this.props == null) {
                    this.props = new ConcurrentHashMap<String, String>();
                }
            }
        }
        this.props.put(prop, value);
        return (T)this;
    }

    public T setProps(Map<String, String> props) {
        if (props != null && !props.isEmpty()) {
            for (Map.Entry<String, String> entry : props.entrySet()) {
                this.setProp(entry.getKey(), entry.getValue());
            }
        }
        return (T)this;
    }

    public String removeProp(String prop) {
        if (this.props != null) {
            String value = this.getProp(prop);
            this.props.remove(prop);
            return value;
        }
        return null;
    }

    @Generated
    public Map<String, String> props() {
        return this.props;
    }

    @Generated
    public ConfigMeta<T> props(Map<String, String> props) {
        this.props = props;
        return this;
    }
}

