/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.miaixz.bus.mapper.builder.TypeResolver;

public class FieldMeta {
    protected Class<?> entityClass;
    protected Field field;

    public FieldMeta() {
    }

    public FieldMeta(Class<?> entityClass, Field field) {
        this.entityClass = entityClass;
        this.field = field;
        this.field.setAccessible(true);
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return TypeResolver.resolveFieldClass(this.field, this.entityClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }

    public Object get(Object obj) {
        try {
            return this.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error getting field value by reflection", e);
        }
    }

    public void set(Object obj, Object value) {
        try {
            this.field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error in reflection setting field value", e);
        }
    }
}

