/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.loader.spi.NormalSpiLoader;
import org.miaixz.bus.mapper.builder.ClassMetaResolver;
import org.miaixz.bus.mapper.builder.ColumnSchemaBuilder;
import org.miaixz.bus.mapper.builder.ColumnSchemaChain;
import org.miaixz.bus.mapper.builder.TableSchemaBuilder;
import org.miaixz.bus.mapper.builder.TableSchemaChain;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.FieldMeta;
import org.miaixz.bus.mapper.parsing.TableMeta;

public abstract class MapperFactory {
    public static TableMeta create(Class<?> mapperType, Method mapperMethod) {
        Optional<Class<?>> optionalClass = ClassMetaResolver.find(mapperType, mapperMethod);
        if (optionalClass.isPresent()) {
            return MapperFactory.create((Class)optionalClass.getOrNull());
        }
        throw new RuntimeException("Can't obtain " + (mapperMethod != null ? mapperMethod.getName() + " method" : mapperType.getSimpleName() + " interface") + " corresponding entity class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMeta create(Class<?> entityClass) {
        TableMeta entityTable = Holder.entityTableFactoryChain.createEntityTable(entityClass);
        if (entityTable == null) {
            throw new NullPointerException("Unable to get " + entityClass.getName() + " entity class information");
        }
        if (!entityTable.ready()) {
            Class<?> clazz = entityClass;
            synchronized (clazz) {
                if (!entityTable.ready()) {
                    Class<?> declaredClass = entityClass;
                    boolean isSuperclass = false;
                    while (declaredClass != null && declaredClass != Object.class) {
                        Object[] declaredFields = declaredClass.getDeclaredFields();
                        if (isSuperclass) {
                            MapperFactory.reverse(declaredFields);
                        }
                        for (Object field : declaredFields) {
                            FieldMeta fieldMeta;
                            int modifiers = ((Field)field).getModifiers();
                            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || entityTable.isExcludeField(fieldMeta = new FieldMeta(entityClass, (Field)field))) continue;
                            Optional<List<ColumnMeta>> optionalEntityColumns = Holder.entityColumnFactoryChain.createEntityColumn(entityTable, fieldMeta);
                            optionalEntityColumns.ifPresent((ConsumerX & Serializable)columns -> columns.forEach(entityTable::addColumn));
                        }
                        for (declaredClass = declaredClass.getSuperclass(); entityTable.isExcludeSuperClass(declaredClass) && declaredClass != Object.class; declaredClass = declaredClass.getSuperclass()) {
                        }
                        isSuperclass = true;
                    }
                    entityTable.ready(true);
                }
            }
        }
        return entityTable;
    }

    protected static void reverse(Object[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            Object temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
    }

    static class Holder {
        static final TableSchemaBuilder.Chain entityTableFactoryChain = new TableSchemaChain(NormalSpiLoader.loadList((boolean)false, TableSchemaBuilder.class));
        static final ColumnSchemaBuilder.Chain entityColumnFactoryChain = new ColumnSchemaChain(NormalSpiLoader.loadList((boolean)false, ColumnSchemaBuilder.class));

        Holder() {
        }
    }
}

