/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.mapper.builder.ClassMetaResolver;
import org.miaixz.bus.mapper.builder.TypeResolver;

public abstract class SchemaTypeParser
implements ClassMetaResolver {
    @Override
    public Optional<Class<?>> findEntityClass(Class<?> mapperType, Method mapperMethod) {
        if (mapperMethod != null) {
            Optional<Class<?>> optionalClass = this.getEntityClassByMapperMethodReturnType(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            optionalClass = this.getEntityClassByMapperMethodParamTypes(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            optionalClass = this.getEntityClassByMapperMethodAndMapperType(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
        }
        return this.getEntityClassByMapperType(mapperType);
    }

    protected Optional<Class<?>> getEntityClassByMapperMethodReturnType(Class<?> mapperType, Method mapperMethod) {
        Class<?> returnType = TypeResolver.getReturnType(mapperMethod, mapperType);
        return this.isEntityClass(returnType) ? Optional.of(returnType) : Optional.empty();
    }

    protected Optional<Class<?>> getEntityClassByMapperMethodParamTypes(Class<?> mapperType, Method mapperMethod) {
        return this.getEntityClassByTypes(TypeResolver.resolveParamTypes(mapperMethod, mapperType));
    }

    protected Optional<Class<?>> getEntityClassByMapperMethodAndMapperType(Class<?> mapperType, Method mapperMethod) {
        return this.getEntityClassByTypes(TypeResolver.resolveMapperTypes(mapperMethod, mapperType));
    }

    protected Optional<Class<?>> getEntityClassByMapperType(Class<?> mapperType) {
        return this.getEntityClassByTypes(TypeResolver.resolveMapperTypes(mapperType));
    }

    protected Optional<Class<?>> getEntityClassByType(Type type) {
        if (type instanceof Class) {
            return Optional.of((Object)((Class)type));
        }
        if (type instanceof TypeResolver.ParameterizedTypes) {
            return this.getEntityClassByTypes(((TypeResolver.ParameterizedTypes)type).getActualTypeArguments());
        }
        if (type instanceof TypeResolver.WildcardTypes) {
            Optional<Class<?>> optionalClass = this.getEntityClassByTypes(((TypeResolver.WildcardTypes)type).getLowerBounds());
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            return this.getEntityClassByTypes(((TypeResolver.WildcardTypes)type).getUpperBounds());
        }
        if (type instanceof TypeResolver.GenericArrayTypes) {
            return this.getEntityClassByType(((TypeResolver.GenericArrayTypes)type).getGenericComponentType());
        }
        return Optional.empty();
    }

    protected Optional<Class<?>> getEntityClassByTypes(Type[] types) {
        for (Type type : types) {
            Optional<Class<?>> optionalClass = this.getEntityClassByType(type);
            if (!optionalClass.isPresent() || !this.isEntityClass((Class)optionalClass.getOrNull())) continue;
            return optionalClass;
        }
        return Optional.empty();
    }
}

