/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.Args;
import org.miaixz.bus.mapper.builder.TypeResolver;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.ConfigMeta;
import org.miaixz.bus.mapper.parsing.FieldMeta;

public class TableMeta
extends ConfigMeta<TableMeta> {
    protected String table;
    protected String catalog;
    protected String schema;
    protected String style;
    protected Class<?> entityClass;
    protected List<ColumnMeta> columns;
    protected boolean ready;
    protected String resultMap;
    protected boolean autoResultMap;
    protected List<ResultMap> resultMaps;
    protected Class<?>[] excludeSuperClasses;
    protected Class<?>[] excludeFieldTypes;
    protected String[] excludeFields;
    protected Set<Configuration> initConfiguration = new HashSet<Configuration>();

    protected TableMeta(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public static TableMeta of(Class<?> entityClass) {
        return new TableMeta(entityClass);
    }

    public String tableName() {
        return Stream.of(this.catalog(), this.schema(), this.table()).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("."));
    }

    public List<ColumnMeta> columns() {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnMeta>();
        }
        return this.columns;
    }

    public List<FieldMeta> fields() {
        return this.columns().stream().map(ColumnMeta::field).collect(Collectors.toList());
    }

    public List<String> columnNames() {
        return this.columns().stream().map(ColumnMeta::column).collect(Collectors.toList());
    }

    public List<String> fieldNames() {
        return this.columns().stream().map(ColumnMeta::property).collect(Collectors.toList());
    }

    public void addColumn(ColumnMeta column) {
        if (!this.columns().contains(column)) {
            if (column.field().getDeclaringClass() != this.entityClass()) {
                this.columns().add(0, column);
            } else {
                this.columns().add(column);
            }
            column.entityTable(this);
        } else {
            ColumnMeta existsColumn = this.columns().remove(this.columns().indexOf(column));
            this.columns().add(0, existsColumn);
        }
    }

    protected boolean canUseResultMaps(ProviderContext providerContext, String cacheKey) {
        if (this.resultMaps != null && !this.resultMaps.isEmpty() && providerContext.getMapperMethod().isAnnotationPresent(SelectProvider.class)) {
            Class resultType = this.resultMaps.get(0).getType();
            if (resultType == providerContext.getMapperMethod().getReturnType()) {
                return true;
            }
            Class<?> returnType = TypeResolver.getReturnType(providerContext.getMapperMethod(), providerContext.getMapperType());
            return resultType == returnType;
        }
        return false;
    }

    public boolean useResultMaps() {
        return this.resultMaps != null || this.autoResultMap || StringKit.isNotEmpty((CharSequence)this.resultMap);
    }

    protected boolean hasBeenReplaced(Configuration configuration, String cacheKey) {
        MappedStatement mappedStatement = configuration.getMappedStatement(cacheKey);
        if (mappedStatement.getResultMaps() != null && mappedStatement.getResultMaps().size() > 0) {
            return mappedStatement.getResultMaps().get(0) == this.resultMaps.get(0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRuntimeContext(Configuration configuration, ProviderContext providerContext, String cacheKey) {
        if (!this.initConfiguration.contains(configuration)) {
            this.initResultMap(configuration, providerContext, cacheKey);
            this.initConfiguration.add(configuration);
        }
        if (this.canUseResultMaps(providerContext, cacheKey)) {
            String string = cacheKey;
            synchronized (string) {
                if (!this.hasBeenReplaced(configuration, cacheKey)) {
                    MetaObject metaObject = configuration.newMetaObject((Object)configuration.getMappedStatement(cacheKey));
                    metaObject.setValue("resultMaps", Collections.unmodifiableList(this.resultMaps));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initResultMap(Configuration configuration, ProviderContext providerContext, String cacheKey) {
        if (StringKit.isNotEmpty((CharSequence)this.resultMap)) {
            TableMeta tableMeta = this;
            synchronized (tableMeta) {
                if (this.resultMaps == null) {
                    this.resultMaps = new ArrayList<ResultMap>();
                    String resultMapId = this.generateResultMapId(providerContext, this.resultMap);
                    if (configuration.hasResultMap(resultMapId)) {
                        this.resultMaps.add(configuration.getResultMap(resultMapId));
                    } else if (configuration.hasResultMap(this.resultMap)) {
                        this.resultMaps.add(configuration.getResultMap(this.resultMap));
                    } else {
                        throw new RuntimeException(this.entityClass().getName() + " configured resultMap: " + this.resultMap + " not found");
                    }
                }
            }
        }
        if (this.autoResultMap) {
            TableMeta tableMeta = this;
            synchronized (tableMeta) {
                if (this.resultMaps == null) {
                    this.resultMaps = new ArrayList<ResultMap>();
                    ResultMap resultMap = this.genResultMap(configuration, providerContext, cacheKey);
                    this.resultMaps.add(resultMap);
                    configuration.addResultMap(resultMap);
                }
            }
        }
    }

    protected String generateResultMapId(ProviderContext providerContext, String resultMapId) {
        if (resultMapId.indexOf(".") > 0) {
            return resultMapId;
        }
        return providerContext.getMapperType().getName() + "." + resultMapId;
    }

    protected ResultMap genResultMap(Configuration configuration, ProviderContext providerContext, String cacheKey) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (ColumnMeta columnMeta : this.selectColumns()) {
            String column = columnMeta.column();
            Matcher matcher = Args.DELIMITER.matcher(column);
            if (matcher.find()) {
                column = matcher.group(1);
            }
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, columnMeta.property(), column, columnMeta.javaType());
            if (columnMeta.jdbcType != null && columnMeta.jdbcType != JdbcType.UNDEFINED) {
                builder.jdbcType(columnMeta.jdbcType);
            }
            if (columnMeta.typeHandler != null && columnMeta.typeHandler != UnknownTypeHandler.class) {
                try {
                    builder.typeHandler(this.getTypeHandlerInstance(columnMeta.javaType(), columnMeta.typeHandler));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (columnMeta.id) {
                flags.add(ResultFlag.ID);
            }
            builder.flags(flags);
            resultMappings.add(builder.build());
        }
        String resultMapId = this.generateResultMapId(providerContext, "BaseProviderResultMap");
        ResultMap.Builder builder = new ResultMap.Builder(configuration, resultMapId, this.entityClass(), resultMappings, Boolean.valueOf(true));
        return builder.build();
    }

    public TypeHandler getTypeHandlerInstance(Class<?> javaTypeClass, Class<?> typeHandlerClass) {
        if (javaTypeClass != null) {
            try {
                Constructor<?> c = typeHandlerClass.getConstructor(Class.class);
                return (TypeHandler)c.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + String.valueOf(typeHandlerClass), (Throwable)e);
            }
        }
        try {
            Constructor<?> c = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TypeException("Unable to find a usable constructor for " + String.valueOf(typeHandlerClass), (Throwable)e);
        }
    }

    public List<ColumnMeta> idColumns() {
        List<ColumnMeta> idColumns = this.columns().stream().filter(ColumnMeta::id).collect(Collectors.toList());
        if (idColumns.isEmpty()) {
            return this.columns();
        }
        return idColumns;
    }

    public List<ColumnMeta> normalColumns() {
        return this.columns().stream().filter(column -> !column.id()).collect(Collectors.toList());
    }

    public List<ColumnMeta> selectColumns() {
        return this.columns().stream().filter(ColumnMeta::selectable).collect(Collectors.toList());
    }

    public List<ColumnMeta> whereColumns() {
        return this.columns();
    }

    public List<ColumnMeta> insertColumns() {
        return this.columns().stream().filter(ColumnMeta::insertable).collect(Collectors.toList());
    }

    public List<ColumnMeta> updateColumns() {
        return this.columns().stream().filter(ColumnMeta::updatable).collect(Collectors.toList());
    }

    public Optional<List<ColumnMeta>> groupByColumns() {
        return Optional.empty();
    }

    public Optional<List<ColumnMeta>> havingColumns() {
        return Optional.empty();
    }

    public Optional<List<ColumnMeta>> orderByColumns() {
        List orderByColumns = this.columns().stream().filter(c -> StringKit.isNotEmpty((CharSequence)c.orderBy)).sorted(Comparator.comparing(ColumnMeta::orderByPriority)).collect(Collectors.toList());
        if (orderByColumns.size() > 0) {
            return Optional.of(orderByColumns);
        }
        return Optional.empty();
    }

    public String baseColumnList() {
        return this.selectColumns().stream().map(ColumnMeta::column).collect(Collectors.joining(","));
    }

    public String baseColumnAsPropertyList() {
        if (this.useResultMaps()) {
            return this.baseColumnList();
        }
        return this.selectColumns().stream().map(ColumnMeta::columnAsProperty).collect(Collectors.joining(","));
    }

    public String insertColumnList() {
        return this.insertColumns().stream().map(ColumnMeta::column).collect(Collectors.joining(","));
    }

    public Optional<String> groupByColumnList() {
        Optional<List<ColumnMeta>> groupByColumns = this.groupByColumns();
        return groupByColumns.map(entityColumns -> entityColumns.stream().map(ColumnMeta::column).collect(Collectors.joining(",")));
    }

    public Optional<String> groupByColumn() {
        Optional<String> groupByColumnList = this.groupByColumnList();
        return groupByColumnList.map(s -> " GROUP BY " + s);
    }

    public Optional<String> havingColumnList() {
        Optional<List<ColumnMeta>> havingColumns = this.havingColumns();
        return havingColumns.map(entityColumns -> entityColumns.stream().map(ColumnMeta::column).collect(Collectors.joining(",")));
    }

    public Optional<String> havingColumn() {
        Optional<String> havingColumnList = this.havingColumnList();
        return havingColumnList.map(s -> " HAVING " + s);
    }

    public Optional<String> orderByColumnList() {
        Optional<List<ColumnMeta>> orderByColumns = this.orderByColumns();
        return orderByColumns.map(entityColumns -> entityColumns.stream().map(column -> column.column() + " " + column.orderBy()).collect(Collectors.joining(",")));
    }

    public Optional<String> orderByColumn() {
        Optional<String> orderColumnList = this.orderByColumnList();
        return orderColumnList.map(s -> " ORDER BY " + s);
    }

    public boolean isExcludeSuperClass(Class<?> superClass) {
        if (this.excludeSuperClasses != null) {
            for (Class<?> clazz : this.excludeSuperClasses) {
                if (clazz != superClass) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExcludeField(FieldMeta field) {
        if (this.excludeFieldTypes != null) {
            Class<?> fieldType = field.getType();
            for (Class<?> clazz : this.excludeFieldTypes) {
                if (clazz != fieldType) continue;
                return true;
            }
        }
        if (this.excludeFields != null) {
            String fieldName = field.getName();
            for (String excludeField : this.excludeFields) {
                if (!excludeField.equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableMeta)) {
            return false;
        }
        TableMeta entity = (TableMeta)o;
        return this.tableName().equals(entity.tableName());
    }

    public int hashCode() {
        return Objects.hash(this.tableName());
    }

    public String toString() {
        return this.tableName();
    }

    @Generated
    public String table() {
        return this.table;
    }

    @Generated
    public String catalog() {
        return this.catalog;
    }

    @Generated
    public String schema() {
        return this.schema;
    }

    @Generated
    public String style() {
        return this.style;
    }

    @Generated
    public Class<?> entityClass() {
        return this.entityClass;
    }

    @Generated
    public boolean ready() {
        return this.ready;
    }

    @Generated
    public String resultMap() {
        return this.resultMap;
    }

    @Generated
    public boolean autoResultMap() {
        return this.autoResultMap;
    }

    @Generated
    public List<ResultMap> resultMaps() {
        return this.resultMaps;
    }

    @Generated
    public Class<?>[] excludeSuperClasses() {
        return this.excludeSuperClasses;
    }

    @Generated
    public Class<?>[] excludeFieldTypes() {
        return this.excludeFieldTypes;
    }

    @Generated
    public String[] excludeFields() {
        return this.excludeFields;
    }

    @Generated
    public Set<Configuration> initConfiguration() {
        return this.initConfiguration;
    }

    @Generated
    public TableMeta table(String table) {
        this.table = table;
        return this;
    }

    @Generated
    public TableMeta catalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    @Generated
    public TableMeta schema(String schema) {
        this.schema = schema;
        return this;
    }

    @Generated
    public TableMeta style(String style) {
        this.style = style;
        return this;
    }

    @Generated
    public TableMeta entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    @Generated
    public TableMeta columns(List<ColumnMeta> columns) {
        this.columns = columns;
        return this;
    }

    @Generated
    public TableMeta ready(boolean ready) {
        this.ready = ready;
        return this;
    }

    @Generated
    public TableMeta resultMap(String resultMap) {
        this.resultMap = resultMap;
        return this;
    }

    @Generated
    public TableMeta autoResultMap(boolean autoResultMap) {
        this.autoResultMap = autoResultMap;
        return this;
    }

    @Generated
    public TableMeta resultMaps(List<ResultMap> resultMaps) {
        this.resultMaps = resultMaps;
        return this;
    }

    @Generated
    public TableMeta excludeSuperClasses(Class<?>[] excludeSuperClasses) {
        this.excludeSuperClasses = excludeSuperClasses;
        return this;
    }

    @Generated
    public TableMeta excludeFieldTypes(Class<?>[] excludeFieldTypes) {
        this.excludeFieldTypes = excludeFieldTypes;
        return this;
    }

    @Generated
    public TableMeta excludeFields(String[] excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }

    @Generated
    public TableMeta initConfiguration(Set<Configuration> initConfiguration) {
        this.initConfiguration = initConfiguration;
        return this;
    }
}

