/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.provider;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.mapper.annotation.Logical;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.SqlScript;
import org.miaixz.bus.mapper.parsing.TableMeta;

public class LogicalProvider {
    public static String select(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "SELECT " + entity.baseColumnAsPropertyList() + " FROM " + entity.tableName() + this.where(() -> entity.whereColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n")) + this.logicalNotEqualCondition(entity)) + entity.groupByColumn().orElse("") + entity.havingColumn().orElse("") + entity.orderByColumn().orElse("");
            }
        });
    }

    public static String selectColumns(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "SELECT " + this.choose(() -> this.whenTest("fns != null and fns.isNotEmpty()", () -> "${fns.baseColumnAsPropertyList()}") + this.otherwise(() -> entity.baseColumnAsPropertyList())) + " FROM " + entity.tableName() + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> this.ifParameterNotNull(() -> this.where(() -> entity.whereColumns().stream().map(column -> this.ifTest(column.notNullTest("entity."), () -> "AND " + column.columnEqualsProperty("entity."))).collect(Collectors.joining("\n")))) + this.logicalNotEqualCondition(entity)) + entity.groupByColumn().orElse("") + entity.havingColumn().orElse("") + entity.orderByColumn().orElse("");
            }
        });
    }

    public static String selectByCondition(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return this.ifTest("startSql != null and startSql != ''", () -> "${startSql}") + "SELECT " + this.ifTest("distinct", () -> "distinct ") + this.ifTest("selectColumns != null and selectColumns != ''", () -> "${selectColumns}") + this.ifTest("selectColumns == null or selectColumns == ''", entity::baseColumnAsPropertyList) + " FROM " + entity.tableName() + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> this.ifParameterNotNull(() -> "<where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n") + this.logicalNotEqualCondition(entity)) + this.ifTest("orderByClause != null", () -> " ORDER BY ${orderByClause}") + this.ifTest("orderByClause == null", () -> entity.orderByColumn().orElse("")) + this.ifTest("endSql != null and endSql != ''", () -> "${endSql}");
            }
        });
    }

    public static String countByCondition(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return this.ifTest("startSql != null and startSql != ''", () -> "${startSql}") + "SELECT COUNT(" + this.ifTest("distinct", () -> "distinct ") + this.ifTest("simpleSelectColumns != null and simpleSelectColumns != ''", () -> "${simpleSelectColumns}") + this.ifTest("simpleSelectColumns == null or simpleSelectColumns == ''", () -> "*") + ") FROM " + entity.tableName() + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> this.ifParameterNotNull(() -> "<where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n") + this.logicalNotEqualCondition(entity)) + this.ifTest("endSql != null and endSql != ''", () -> "${endSql}");
            }
        });
    }

    public static String selectByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "SELECT " + entity.baseColumnAsPropertyList() + " FROM " + entity.tableName() + this.where(() -> entity.idColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(" AND "))) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String selectCount(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "SELECT COUNT(*)  FROM " + entity.tableName() + "\n" + this.where(() -> entity.whereColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n")) + this.logicalNotEqualCondition(entity));
            }
        });
    }

    public static String updateByCondition(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return this.ifTest("condition.startSql != null and condition.startSql != ''", () -> "${condition.startSql}") + "UPDATE " + entity.tableName() + this.set(() -> entity.updateColumns().stream().map(column -> column.columnEqualsProperty("entity.")).collect(Collectors.joining(","))) + this.variableNotNull("condition", "Condition cannot be null") + (entity.getPropBoolean("updateByCondition.allowEmpty", true) != false ? "" : this.variableIsFalse("condition.isEmpty()", "Condition Criteria cannot be empty")) + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> "<where>\n  <foreach collection=\"condition.oredCriteria\" item=\"criteria\"\n separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n" + this.logicalNotEqualCondition(entity)) + this.ifTest("condition.endSql != null and condition.endSql != ''", () -> "${condition.endSql}");
            }
        });
    }

    public static String updateByConditionSelective(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return this.ifTest("condition.startSql != null and condition.startSql != ''", () -> "${condition.startSql}") + "UPDATE " + entity.tableName() + this.set(() -> entity.updateColumns().stream().map(column -> this.ifTest(column.notNullTest("entity."), () -> column.columnEqualsProperty("entity.") + ",")).collect(Collectors.joining("\n"))) + this.variableNotNull("condition", "Condition cannot be null") + (entity.getPropBoolean("updateByConditionSelective.allowEmpty", true) != false ? "" : this.variableIsFalse("condition.isEmpty()", "Condition Criteria cannot be empty")) + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> "<where>\n  <foreach collection=\"condition.oredCriteria\" item=\"criteria\"\n separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n" + this.logicalNotEqualCondition(entity)) + this.ifTest("condition.endSql != null and condition.endSql != ''", () -> "${condition.endSql}");
            }
        });
    }

    public static String updateByConditionSetValues(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return this.ifTest("condition.startSql != null and condition.startSql != ''", () -> "${condition.startSql}") + this.variableNotEmpty("condition.setValues", "Condition setValues cannot be empty") + "UPDATE " + entity.tableName() + "<set>  <foreach collection=\"condition.setValues\" item=\"setValue\">\n    <choose>\n      <when test=\"setValue.noValue\">\n        ${setValue.condition},\n      </when>\n      <when test=\"setValue.singleValue\">\n        ${setValue.condition} = ${setValue.variables('setValue.value')},\n      </when>\n    </choose>\n  </foreach>\n</set>" + this.variableNotNull("condition", "Condition cannot be null") + (entity.getPropBoolean("updateByCondition.allowEmpty", true) != false ? "" : this.variableIsFalse("condition.isEmpty()", "Condition Criteria cannot be empty")) + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> "<where>\n  <foreach collection=\"condition.oredCriteria\" item=\"criteria\"\n separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n" + this.logicalNotEqualCondition(entity)) + this.ifTest("condition.endSql != null and condition.endSql != ''", () -> "${condition.endSql}");
            }
        });
    }

    public static String updateByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "UPDATE " + entity.tableName() + " SET " + entity.updateColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(",")) + this.where(() -> entity.idColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(" AND "))) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String updateByPrimaryKeySelective(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "UPDATE " + entity.tableName() + this.set(() -> entity.updateColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> column.columnEqualsProperty() + ",")).collect(Collectors.joining("\n"))) + this.where(() -> entity.idColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(" AND "))) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String updateByPrimaryKeySelectiveWithForceFields(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "UPDATE " + entity.tableName() + this.set(() -> entity.updateColumns().stream().map(column -> this.choose(() -> this.whenTest("fns != null and fns.fieldNames().contains('" + column.property() + "')", () -> column.columnEqualsProperty("entity.") + ",") + this.whenTest(column.notNullTest("entity."), () -> column.columnEqualsProperty("entity.") + ","))).collect(Collectors.joining("\n"))) + this.where(() -> entity.idColumns().stream().map(column -> column.columnEqualsProperty("entity.")).collect(Collectors.joining(" AND "))) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String delete(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                ColumnMeta logicColumn = LogicalProvider.getLogical(entity);
                return "UPDATE " + entity.tableName() + " SET " + LogicalProvider.columnEqualsValue(logicColumn, LogicalProvider.deleteValue(logicColumn)) + this.parameterNotNull("Parameter cannot be null") + this.where(() -> entity.columns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n")) + this.logicalNotEqualCondition(entity));
            }
        });
    }

    public static String deleteByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new LogicalSqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                ColumnMeta logicColumn = LogicalProvider.getLogical(entity);
                return "UPDATE " + entity.tableName() + " SET " + LogicalProvider.columnEqualsValue(logicColumn, LogicalProvider.deleteValue(logicColumn)) + " WHERE " + entity.idColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(" AND ")) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String deleteByCondition(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, (entity, util) -> {
            ColumnMeta logicColumn = LogicalProvider.getLogical(entity);
            return util.ifTest("startSql != null and startSql != ''", () -> "${startSql}") + "UPDATE " + entity.tableName() + " SET " + LogicalProvider.columnEqualsValue(logicColumn, LogicalProvider.deleteValue(logicColumn)) + util.parameterNotNull("Condition cannot be null") + (entity.getPropBoolean("deleteByCondition.allowEmpty", true) != false ? "" : util.variableIsFalse("_parameter.isEmpty()", "Condition Criteria cannot be empty")) + "<where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n              <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} ${criterion.variables('criterion.value')} AND\n              ${criterion.variables('criterion.secondValue')}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                ${criterion.variables('listItem')}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n AND " + LogicalProvider.columnNotEqualsValueCondition(logicColumn, LogicalProvider.deleteValue(logicColumn)) + util.ifTest("endSql != null and endSql != ''", () -> "${endSql}");
        });
    }

    private static ColumnMeta getLogical(TableMeta entity) {
        List logicColumns = entity.columns().stream().filter(c -> c.field().isAnnotationPresent(Logical.class)).collect(Collectors.toList());
        Assert.isTrue((logicColumns.size() == 1 ? 1 : 0) != 0, (String)"There are no or multiple fields marked with @Logical", (Object[])new Object[0]);
        return (ColumnMeta)logicColumns.get(0);
    }

    private static String deleteValue(ColumnMeta logicColumn) {
        return logicColumn.field().getAnnotation(Logical.class).value();
    }

    private static String columnEqualsValueCondition(ColumnMeta c, String value) {
        return " " + c.column() + LogicalProvider.choiceEqualsOperator(value) + value + " ";
    }

    private static String columnEqualsValue(ColumnMeta c, String value) {
        return " " + c.column() + " = " + value + " ";
    }

    private static String columnNotEqualsValueCondition(ColumnMeta c, String value) {
        return " " + c.column() + LogicalProvider.choiceNotEqualsOperator(value) + value;
    }

    private static String choiceEqualsOperator(String value) {
        if ("null".compareToIgnoreCase(value) == 0) {
            return " IS ";
        }
        return " = ";
    }

    private static String choiceNotEqualsOperator(String value) {
        if ("null".compareToIgnoreCase(value) == 0) {
            return " IS NOT ";
        }
        return " != ";
    }

    private static interface LogicalSqlScript
    extends SqlScript {
        default public String logicalNotEqualCondition(TableMeta entity) {
            ColumnMeta logicalColumn = LogicalProvider.getLogical(entity);
            return " AND " + LogicalProvider.columnNotEqualsValueCondition(logicalColumn, LogicalProvider.deleteValue(logicalColumn)) + "\n";
        }
    }
}

