/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper;

import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.miaixz.bus.core.lang.loader.spi.NormalSpiLoader;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.Args;
import org.miaixz.bus.mapper.ORDER;
import org.miaixz.bus.mapper.binding.function.Fn;
import org.miaixz.bus.mapper.support.ClassColumn;
import org.miaixz.bus.mapper.support.ClassField;

public class OGNL {
    public static final Pattern SQL_SYNTAX_PATTERN = Pattern.compile("(?i)(?:\\b(insert\\s+into\\s+\\w+|delete\\s+from\\s+\\w+|update\\s+\\w+\\s*(?:set\\s+.*)?|create\\s+(table|database|view|index|procedure|trigger)\\s+\\w+|drop\\s+(table|database|view|index)\\s+\\w+|truncate\\s+table\\s+\\w+|grant\\s+.*\\s+on\\s+.*|alter\\s+(table|database)\\s+\\w+|deny\\s+.*\\s+on\\s+.*|revoke\\s+.*\\s+on\\s+.*|call\\s+\\w+|execute\\s+\\w+|exec\\s+\\w+|declare\\s+@\\w+|show\\s+(databases|tables|columns)|rename\\s+table\\s+\\w+|set\\s+password|union\\s+select\\s+.*|insert\\s+\\w+)(?:\\s*(?:;|\\/\\*|\\-\\-)|\\b)|\\b(if|substr|substring|char|concat|benchmark|sleep)\\s*\\([^)]*\\)|\\b(or|and)\\s+['\"0-1]=['\"0-1])", 2);
    public static final Pattern SQL_COMMENT_PATTERN = Pattern.compile("'.*(or|union|--|#|/\\*|;)", 2);
    public static final Pattern REPLACE_BLANK = Pattern.compile("'|\"|\\<|\\>|&|\\*|\\+|=|#|-|;|\\s*|\t|\r|\n");

    public static void registerSimpleType(Class<?> clazz) {
        Args.SIMPLE_TYPE_SET.add(clazz);
    }

    public static void registerSimpleType(String classes) {
        if (StringKit.isNotEmpty((CharSequence)classes)) {
            String[] cls;
            for (String c : cls = classes.split(",")) {
                try {
                    Args.SIMPLE_TYPE_SET.add(Class.forName(c));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Failed to register type: " + c, e);
                }
            }
        }
    }

    public static void registerSimpleTypeSilence(String clazz) {
        try {
            Args.SIMPLE_TYPE_SET.add(Class.forName(clazz));
        }
        catch (ClassNotFoundException e) {
            Logger.debug((String)("Class not found, ignored: " + clazz), (Object[])new Object[0]);
        }
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return Args.SIMPLE_TYPE_SET.contains(clazz);
    }

    public static <T> List<T> getInstances(Class<T> clazz) {
        List list = NormalSpiLoader.loadList((boolean)false, clazz);
        if (list.size() > 1 && ORDER.class.isAssignableFrom(clazz)) {
            list.sort(Comparator.comparing(f -> ((ORDER)f).order()).reversed());
        }
        return list;
    }

    public static ClassField fnToFieldName(Fn<?, ?> fn) {
        try {
            Class<?> clazz = null;
            if (fn instanceof Fn.FnName) {
                Fn.FnName field = (Fn.FnName)fn;
                if (field.column) {
                    return new ClassColumn(field.entityClass, field.name);
                }
                return new ClassField(field.entityClass, field.name);
            }
            if (fn instanceof Fn.FnType) {
                clazz = ((Fn.FnType)fn).entityClass;
                fn = ((Fn.FnType)fn).fn;
                while (fn instanceof Fn.FnType) {
                    fn = ((Fn.FnType)fn).fn;
                }
            }
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(fn, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            if (Args.GET_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(3);
            } else if (Args.IS_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(2);
            }
            String field = Introspector.decapitalize(getter);
            if (clazz == null) {
                Matcher matcher = Args.CLASS_PATTERN.matcher(serializedLambda.getInstantiatedMethodType());
                String implClass = matcher.find() ? matcher.group("cls").replaceAll("/", "\\.") : serializedLambda.getImplClass().replaceAll("/", "\\.");
                clazz = Class.forName(implClass);
            }
            return new ClassField(clazz, field);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to convert Fn to field name", e);
        }
    }

    public static boolean validateSql(String value) {
        Objects.requireNonNull(value);
        return SQL_COMMENT_PATTERN.matcher(value).find() || SQL_SYNTAX_PATTERN.matcher(value).find();
    }

    public static String injection(String value) {
        if (OGNL.validateSql(value)) {
            value = OGNL.replaceAllBlank(value);
        }
        return value;
    }

    public static String replaceAllBlank(String value) {
        Matcher matcher = REPLACE_BLANK.matcher(value);
        return matcher.replaceAll("");
    }

    public static String removeEscapeCharacter(String text) {
        Objects.requireNonNull(text);
        return text.replaceAll("\"", "").replaceAll("'", "");
    }

    public static String convertIf(String sqlScript, String ifTest, boolean newLine) {
        Object newSqlScript = sqlScript;
        if (newLine) {
            newSqlScript = "\n" + (String)newSqlScript + "\n";
        }
        return String.format("<if test=\"%s\">%s</if>", ifTest, newSqlScript);
    }

    public static String convertTrim(String sqlScript, String prefix, String suffix, String prefixOverrides, String suffixOverrides) {
        StringBuilder sb = new StringBuilder("<trim");
        if (StringKit.isNotBlank((CharSequence)prefix)) {
            sb.append(" prefix=\"").append(prefix).append("'");
        }
        if (StringKit.isNotBlank((CharSequence)suffix)) {
            sb.append(" suffix=\"").append(suffix).append("'");
        }
        if (StringKit.isNotBlank((CharSequence)prefixOverrides)) {
            sb.append(" prefixOverrides=\"").append(prefixOverrides).append("'");
        }
        if (StringKit.isNotBlank((CharSequence)suffixOverrides)) {
            sb.append(" suffixOverrides=\"").append(suffixOverrides).append("'");
        }
        return sb.append(">").append("\n").append(sqlScript).append("\n").append("</trim>").toString();
    }

    public static String convertChoose(String whenTest, String whenSqlScript, String otherwise) {
        return "<choose>\n<when test=\"" + whenTest + "'>\n" + whenSqlScript + "\n</when>\n<otherwise>" + otherwise + "</otherwise>\n</choose>";
    }

    public static String convertForeach(String sqlScript, String collection, String index, String item, String separator) {
        StringBuilder sb = new StringBuilder("<foreach");
        if (StringKit.isNotBlank((CharSequence)collection)) {
            sb.append(" collection=\"").append(collection).append("'");
        }
        if (StringKit.isNotBlank((CharSequence)index)) {
            sb.append(" index=\"").append(index).append("'");
        }
        if (StringKit.isNotBlank((CharSequence)item)) {
            sb.append(" item=\"").append(item).append("'");
        }
        if (StringKit.isNotBlank((CharSequence)separator)) {
            sb.append(" separator=\"").append(separator).append("'");
        }
        return sb.append(">").append("\n").append(sqlScript).append("\n").append("</foreach>").toString();
    }

    public static String convertWhere(String sqlScript) {
        return "<where>\n" + sqlScript + "\n</where>";
    }

    public static String convertSet(String sqlScript) {
        return "<set>\n" + sqlScript + "\n</set>";
    }

    public static String safeParam(String param) {
        return OGNL.safeParam(param, null);
    }

    public static String safeParam(String param, String mapping) {
        String target = "#{" + param;
        if (StringKit.isBlank((CharSequence)mapping)) {
            return target + "}";
        }
        return target + "," + mapping + "}";
    }

    public static String unSafeParam(String param) {
        return "${" + param + "}";
    }

    public static String mappingTypeHandler(Class<? extends TypeHandler<?>> typeHandler) {
        if (typeHandler != null) {
            return "typeHandler=" + typeHandler.getName();
        }
        return null;
    }

    public static String mappingJdbcType(JdbcType jdbcType) {
        if (jdbcType != null) {
            return "jdbcType=" + jdbcType.name();
        }
        return null;
    }

    public static String mappingNumericScale(Integer numericScale) {
        if (numericScale != null) {
            return "numericScale=" + numericScale;
        }
        return null;
    }

    public static String convertParamMapping(Class<? extends TypeHandler<?>> typeHandler, JdbcType jdbcType, Integer numericScale) {
        if (typeHandler == null && jdbcType == null && numericScale == null) {
            return null;
        }
        String mapping = null;
        if (typeHandler != null) {
            mapping = OGNL.mappingTypeHandler(typeHandler);
        }
        if (jdbcType != null) {
            mapping = OGNL.appendMapping(mapping, OGNL.mappingJdbcType(jdbcType));
        }
        if (numericScale != null) {
            mapping = OGNL.appendMapping(mapping, OGNL.mappingNumericScale(numericScale));
        }
        return mapping;
    }

    private static String appendMapping(String mapping, String other) {
        if (mapping != null) {
            return mapping + "," + other;
        }
        return other;
    }
}

