/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.binding.basic;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.mapper.builder.GenericTypeResolver;
import org.miaixz.bus.mapper.parsing.MapperFactory;
import org.miaixz.bus.mapper.parsing.TableMeta;

public interface ClassMapper<T> {
    default public Class<T> entityClass() {
        return CachingEntityClass.getEntityClass(this.getClass());
    }

    default public TableMeta entityTable() {
        return MapperFactory.create(this.entityClass());
    }

    public static class CachingEntityClass {
        static Map<Class<?>, Class<?>> entityClassMap = new ConcurrentHashMap();

        private static Class<?> getEntityClass(Class<?> clazz) {
            if (!entityClassMap.containsKey(clazz)) {
                entityClassMap.put(clazz, GenericTypeResolver.resolveTypeToClass(GenericTypeResolver.resolveType(ClassMapper.class.getTypeParameters()[0], clazz, ClassMapper.class)));
            }
            return entityClassMap.get(clazz);
        }
    }
}

