/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.binding.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.miaixz.bus.mapper.OGNL;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.MapperFactory;
import org.miaixz.bus.mapper.parsing.TableMeta;
import org.miaixz.bus.mapper.support.ClassField;

public interface Fn<T, R>
extends Function<T, R>,
Serializable {
    public static final Map<Fn<?, ?>, ColumnMeta> FN_COLUMN_MAP = new ConcurrentHashMap();
    public static final Map<Fn<?, ?>, ClassField> FN_CLASS_FIELD_MAP = new ConcurrentHashMap();

    @SafeVarargs
    public static <E> FnArray<E> of(Class<E> entityClass, Fn<E, Object> ... fns) {
        return new FnArray<E>(entityClass, fns);
    }

    @SafeVarargs
    public static <E> FnArray<E> of(Fn<E, Object> ... fns) {
        return Fn.of(null, fns);
    }

    public static <E> FnArray<E> of(Class<E> entityClass, String ... columnNames) {
        TableMeta entityTable = MapperFactory.create(entityClass);
        Set columnNameSet = Arrays.stream(columnNames).collect(Collectors.toSet());
        List<ColumnMeta> columns = entityTable.columns().stream().filter(column -> columnNameSet.contains(column.property())).collect(Collectors.toList());
        return new FnArray<E>(entityClass, entityTable.tableName(), columns);
    }

    public static <T> Fn<T, Object> field(Class<T> entityClass, Fn<T, Object> field) {
        return field.in(entityClass);
    }

    public static <T> Fn<T, Object> field(Class<T> entityClass, String field) {
        return new FnName(entityClass, field);
    }

    public static <T> Fn<T, Object> column(Class<T> entityClass, String column) {
        return new FnName(entityClass, column, true);
    }

    default public Fn<T, R> in(Class<?> entityClass) {
        return new FnType(this, entityClass);
    }

    default public String toField() {
        return this.toClassField().getField();
    }

    default public String toColumn() {
        return this.toEntityColumn().column();
    }

    default public ClassField toClassField() {
        return FN_CLASS_FIELD_MAP.computeIfAbsent(this, key -> OGNL.fnToFieldName(key));
    }

    default public ColumnMeta toEntityColumn() {
        return FN_COLUMN_MAP.computeIfAbsent(this, key -> {
            ClassField classField = this.toClassField();
            List<ColumnMeta> columns = MapperFactory.create(classField.getClazz()).columns();
            return columns.stream().filter(column -> column.property().equals(classField.getField())).findFirst().orElseGet(() -> columns.stream().filter(classField).findFirst().orElseThrow(() -> new RuntimeException(classField.getField() + " does not mark database column field annotations, unable to obtain column information")));
        });
    }

    public static class FnArray<E>
    extends TableMeta {
        private FnArray(Class<E> entityClass, String table, List<ColumnMeta> columns) {
            super(entityClass);
            this.table = table;
            this.columns = columns;
        }

        @SafeVarargs
        private FnArray(Class<E> entityClass, Fn<E, Object> ... fns) {
            super(entityClass);
            this.columns = new ArrayList(fns.length);
            for (int i = 0; i < fns.length; ++i) {
                if (entityClass != null) {
                    this.columns.add(fns[i].in(entityClass).toEntityColumn());
                } else {
                    this.columns.add(fns[i].toEntityColumn());
                }
                if (i != 0) continue;
                TableMeta entityTable = ((ColumnMeta)this.columns.get(i)).tableMeta();
                this.table = entityTable.tableName();
                this.style = entityTable.style();
                this.entityClass = entityTable.entityClass();
                this.resultMap = entityTable.resultMap();
                this.autoResultMap = entityTable.autoResultMap();
            }
        }

        public boolean isNotEmpty() {
            return !this.columns().isEmpty();
        }
    }

    public static class FnName<T, R>
    implements Fn<T, R> {
        public final Class<?> entityClass;
        public final String name;
        public final boolean column;

        public FnName(Class<?> entityClass, String name) {
            this(entityClass, name, false);
        }

        public FnName(Class<?> entityClass, String name, boolean column) {
            this.entityClass = entityClass;
            this.name = name;
            this.column = column;
        }

        @Override
        public Fn<T, R> in(Class<?> entityClass) {
            return new FnName<T, R>(entityClass, this.name, this.column);
        }

        @Override
        public R apply(Object o) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FnName fnName = (FnName)o;
            return this.column == fnName.column && Objects.equals(this.entityClass, fnName.entityClass) && Objects.equals(this.name, fnName.name);
        }

        public int hashCode() {
            return Objects.hash(this.entityClass, this.name, this.column);
        }
    }

    public static class FnType<T, R>
    implements Fn<T, R> {
        public final Fn<T, R> fn;
        public final Class<?> entityClass;

        public FnType(Fn<T, R> fn, Class<?> entityClass) {
            this.fn = fn;
            this.entityClass = entityClass;
        }

        @Override
        public R apply(T t) {
            return this.fn.apply(t);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FnType fnType = (FnType)o;
            return Objects.equals(this.entityClass, fnType.entityClass) && Objects.equals(this.fn, fnType.fn);
        }

        public int hashCode() {
            return Objects.hash(this.entityClass, this.fn);
        }
    }
}

