/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Id;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Transient;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.type.TypeHandler;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.mapper.builder.ColumnSchemaBuilder;
import org.miaixz.bus.mapper.builder.EntityClassBuilder;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.FieldMeta;
import org.miaixz.bus.mapper.parsing.TableMeta;
import org.miaixz.bus.mapper.provider.NamingProvider;

public class ColumnAnnotationBuilder
implements ColumnSchemaBuilder {
    private static final Optional<List<ColumnMeta>> IGNORE = Optional.of(Collections.emptyList());

    @Override
    public Optional<List<ColumnMeta>> createColumn(TableMeta tableMeta, FieldMeta fieldMeta, ColumnSchemaBuilder.Chain chain) {
        Optional columns = chain.createColumn(tableMeta, fieldMeta);
        if (columns == IGNORE || fieldMeta.isAnnotationPresent(Transient.class)) {
            return IGNORE;
        }
        if (!columns.isPresent()) {
            String columnName = NamingProvider.getDefaultStyle().columnName(tableMeta, fieldMeta);
            columns = Optional.of(Collections.singletonList(ColumnMeta.of(fieldMeta).column(columnName)));
        }
        if (columns.isPresent()) {
            List columnList = (List)columns.getOrNull();
            for (ColumnMeta columnMeta : columnList) {
                this.processAnnotations(columnMeta, fieldMeta);
                EntityClassBuilder.setColumnMeta(tableMeta.entityClass(), columnMeta);
            }
        }
        return columns;
    }

    protected void processAnnotations(ColumnMeta columnMeta, FieldMeta fieldMeta) {
        Convert convert;
        Class converter;
        if (!columnMeta.id() && fieldMeta.isAnnotationPresent(Id.class)) {
            columnMeta.id(true);
        }
        if (fieldMeta.isAnnotationPresent(Column.class)) {
            Column column = fieldMeta.getAnnotation(Column.class);
            if (!column.name().isEmpty()) {
                columnMeta.column(column.name());
            }
            columnMeta.insertable(column.insertable()).updatable(column.updatable());
            if (column.scale() != 0) {
                columnMeta.numericScale(String.valueOf(column.scale()));
            }
        }
        if (fieldMeta.isAnnotationPresent(OrderBy.class)) {
            OrderBy orderBy = fieldMeta.getAnnotation(OrderBy.class);
            columnMeta.orderBy(orderBy.value().isEmpty() ? "ASC" : orderBy.value());
        }
        if (fieldMeta.isAnnotationPresent(Convert.class) && (converter = (convert = fieldMeta.getAnnotation(Convert.class)).converter()) != Void.TYPE && TypeHandler.class.isAssignableFrom(converter)) {
            columnMeta.typeHandler(converter);
        }
    }
}

