/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.lang.annotation.Logical;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.FieldMeta;
import org.miaixz.bus.mapper.parsing.TableMeta;

public class EntityClassBuilder {
    private static final Map<Class<?>, TableMeta> TABLE_META_STORE = new HashMap();
    private static final Map<Class<?>, List<ColumnMeta>> COLUMN_META_STORE = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTableMeta(TableMeta tableMeta) {
        Map<Class<?>, TableMeta> map = TABLE_META_STORE;
        synchronized (map) {
            TABLE_META_STORE.put(tableMeta.entityClass(), tableMeta);
            COLUMN_META_STORE.computeIfAbsent(tableMeta.entityClass(), k -> new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setColumnMeta(Class<?> entityClass, ColumnMeta columnMeta) {
        Map<Class<?>, List<ColumnMeta>> map = COLUMN_META_STORE;
        synchronized (map) {
            List columnMetas = COLUMN_META_STORE.computeIfAbsent(entityClass, k -> new ArrayList());
            columnMetas.add(columnMeta);
            TableMeta tableMeta = TABLE_META_STORE.get(entityClass);
            if (tableMeta == null) {
                throw new RuntimeException("TableMeta for " + entityClass.getName() + " not initialized");
            }
            tableMeta.addColumn(columnMeta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMeta getTableMeta() {
        Map<Class<?>, TableMeta> map = TABLE_META_STORE;
        synchronized (map) {
            if (TABLE_META_STORE.isEmpty()) {
                throw new RuntimeException("No TableMeta initialized");
            }
            return TABLE_META_STORE.values().iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMeta getTableMeta(Class<?> entityClass) {
        Map<Class<?>, TableMeta> map = TABLE_META_STORE;
        synchronized (map) {
            TableMeta tableMeta = TABLE_META_STORE.get(entityClass);
            if (tableMeta == null) {
                throw new RuntimeException("TableMeta for " + entityClass.getName() + " not initialized");
            }
            return tableMeta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnMeta> getColumnMeta() {
        Map<Class<?>, List<ColumnMeta>> map = COLUMN_META_STORE;
        synchronized (map) {
            if (COLUMN_META_STORE.isEmpty()) {
                throw new RuntimeException("No ColumnMeta initialized");
            }
            return Collections.unmodifiableList(COLUMN_META_STORE.values().iterator().next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnMeta> getColumnMeta(Class<?> entityClass) {
        Map<Class<?>, List<ColumnMeta>> map = COLUMN_META_STORE;
        synchronized (map) {
            List<ColumnMeta> columnMetas = COLUMN_META_STORE.get(entityClass);
            if (columnMetas == null) {
                throw new RuntimeException("ColumnMeta for " + entityClass.getName() + " not initialized");
            }
            return Collections.unmodifiableList(columnMetas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Annotation> List<T> getTableAnnotations(Class<T> annotationClass) {
        Map<Class<?>, TableMeta> map = TABLE_META_STORE;
        synchronized (map) {
            if (TABLE_META_STORE.isEmpty()) {
                throw new RuntimeException("No TableMeta initialized");
            }
            return EntityClassBuilder.getAnnotationsFromTableMeta(TABLE_META_STORE.values().iterator().next(), annotationClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Annotation> List<T> getTableAnnotations(Class<?> entityClass, Class<T> annotationClass) {
        Map<Class<?>, TableMeta> map = TABLE_META_STORE;
        synchronized (map) {
            TableMeta tableMeta = TABLE_META_STORE.get(entityClass);
            if (tableMeta == null) {
                throw new RuntimeException("TableMeta for " + entityClass.getName() + " not initialized");
            }
            return EntityClassBuilder.getAnnotationsFromTableMeta(tableMeta, annotationClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Annotation> List<T> getColumnAnnotations(Class<T> annotationClass) {
        Map<Class<?>, List<ColumnMeta>> map = COLUMN_META_STORE;
        synchronized (map) {
            if (COLUMN_META_STORE.isEmpty()) {
                throw new RuntimeException("No ColumnMeta initialized");
            }
            return EntityClassBuilder.getAnnotationsFromColumnMetas(COLUMN_META_STORE.values().iterator().next(), annotationClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Annotation> List<T> getColumnAnnotations(Class<?> entityClass, Class<T> annotationClass) {
        Map<Class<?>, List<ColumnMeta>> map = COLUMN_META_STORE;
        synchronized (map) {
            List<ColumnMeta> columnMetas = COLUMN_META_STORE.get(entityClass);
            if (columnMetas == null) {
                throw new RuntimeException("ColumnMeta for " + entityClass.getName() + " not initialized");
            }
            return EntityClassBuilder.getAnnotationsFromColumnMetas(columnMetas, annotationClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableLogicColumn() {
        Map<Class<?>, List<ColumnMeta>> map = COLUMN_META_STORE;
        synchronized (map) {
            if (COLUMN_META_STORE.isEmpty()) {
                return "";
            }
            for (ColumnMeta columnMeta : COLUMN_META_STORE.values().iterator().next()) {
                FieldMeta fieldMeta = columnMeta.fieldMeta();
                if (fieldMeta == null || !fieldMeta.isAnnotationPresent(Logical.class)) continue;
                return columnMeta.column();
            }
            return "";
        }
    }

    private static <T extends Annotation> List<T> getAnnotationsFromTableMeta(TableMeta tableMeta, Class<T> annotationClass) {
        T annotation;
        ArrayList<T> annotations = new ArrayList<T>();
        if (tableMeta != null && tableMeta.entityClass().isAnnotationPresent(annotationClass) && (annotation = tableMeta.entityClass().getAnnotation(annotationClass)) != null) {
            annotations.add(annotation);
        }
        return Collections.unmodifiableList(annotations);
    }

    private static <T extends Annotation> List<T> getAnnotationsFromColumnMetas(List<ColumnMeta> columnMetas, Class<T> annotationClass) {
        ArrayList<T> annotations = new ArrayList<T>();
        for (ColumnMeta columnMeta : columnMetas) {
            T annotation;
            FieldMeta fieldMeta = columnMeta.fieldMeta();
            if (fieldMeta == null || !fieldMeta.isAnnotationPresent(annotationClass) || (annotation = fieldMeta.getAnnotation(annotationClass)) == null) continue;
            annotations.add(annotation);
        }
        return Collections.unmodifiableList(annotations);
    }
}

