/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.cursor.Cursor;

public class GenericTypeResolver {
    public static Class<?> getReturnType(Method method, Class<?> srcType) {
        Class returnType = method.getReturnType();
        Type resolvedReturnType = GenericTypeResolver.resolveReturnType(method, srcType);
        if (resolvedReturnType instanceof Class) {
            ResultType rt;
            returnType = (Class)resolvedReturnType;
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            }
            if (Void.TYPE.equals(returnType) && (rt = method.getAnnotation(ResultType.class)) != null) {
                returnType = rt.value();
            }
        } else if (resolvedReturnType instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            Type returnTypeParameter;
            ParameterizedType parameterizedType = (ParameterizedType)resolvedReturnType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawType) || Cursor.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments2 = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments2 != null && actualTypeArguments2.length == 1) {
                    Type returnTypeParameter2 = actualTypeArguments2[0];
                    if (returnTypeParameter2 instanceof Class) {
                        returnType = (Class)returnTypeParameter2;
                    } else if (returnTypeParameter2 instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter2).getRawType();
                    } else if (returnTypeParameter2 instanceof GenericArrayType) {
                        Class componentType = (Class)((GenericArrayType)returnTypeParameter2).getGenericComponentType();
                        returnType = Array.newInstance(componentType, 0).getClass();
                    }
                }
            } else if (method.isAnnotationPresent(MapKey.class) && Map.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments3 = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments3 != null && actualTypeArguments3.length == 2) {
                    Type returnTypeParameter3 = actualTypeArguments3[1];
                    if (returnTypeParameter3 instanceof Class) {
                        returnType = (Class)returnTypeParameter3;
                    } else if (returnTypeParameter3 instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter3).getRawType();
                    }
                }
            } else if (Optional.class.equals((Object)rawType) && (returnTypeParameter = (actualTypeArguments = parameterizedType.getActualTypeArguments())[0]) instanceof Class) {
                returnType = (Class)returnTypeParameter;
            }
        }
        return returnType;
    }

    public static Type[] resolveMapperTypes(Class<?> srcType) {
        Type[] types = srcType.getGenericInterfaces();
        ArrayList<Type> result = new ArrayList<Type>();
        for (Type type : types) {
            if (type instanceof Class) {
                result.addAll(Arrays.asList(GenericTypeResolver.resolveMapperTypes((Class)type)));
                continue;
            }
            if (!(type instanceof ParameterizedType)) continue;
            Collections.addAll(result, ((ParameterizedType)type).getActualTypeArguments());
        }
        return result.toArray(new Type[0]);
    }

    public static Type[] resolveMapperTypes(Method method, Type srcType) {
        Class<?> declaringClass = method.getDeclaringClass();
        TypeVariable<Class<?>>[] typeParameters = declaringClass.getTypeParameters();
        Type[] result = new Type[typeParameters.length];
        for (int i = 0; i < typeParameters.length; ++i) {
            result[i] = GenericTypeResolver.resolveType(typeParameters[i], srcType, declaringClass);
        }
        return result;
    }

    public static Type resolveFieldType(Field field, Type srcType) {
        Type fieldType = field.getGenericType();
        Class<?> declaringClass = field.getDeclaringClass();
        return GenericTypeResolver.resolveType(fieldType, srcType, declaringClass);
    }

    public static Class<?> resolveFieldClass(Field field, Type srcType) {
        Type fieldType = field.getGenericType();
        Class<?> declaringClass = field.getDeclaringClass();
        Type type = GenericTypeResolver.resolveType(fieldType, srcType, declaringClass);
        return GenericTypeResolver.resolveTypeToClass(type);
    }

    public static Class<?> resolveTypeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            return (Class)bounds[0];
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            if (componentType instanceof Class) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
            Class<?> componentClass = GenericTypeResolver.resolveTypeToClass(componentType);
            return Array.newInstance(componentClass, 0).getClass();
        }
        return Object.class;
    }

    public static Type resolveReturnType(Method method, Type srcType) {
        Type returnType = method.getGenericReturnType();
        Class<?> declaringClass = method.getDeclaringClass();
        return GenericTypeResolver.resolveType(returnType, srcType, declaringClass);
    }

    public static Type[] resolveParamTypes(Method method, Type srcType) {
        Type[] paramTypes = method.getGenericParameterTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        Type[] result = new Type[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            result[i] = GenericTypeResolver.resolveType(paramTypes[i], srcType, declaringClass);
        }
        return result;
    }

    public static Type resolveType(Type type, Type srcType, Class<?> declaringClass) {
        if (type instanceof TypeVariable) {
            return GenericTypeResolver.resolveTypeVar((TypeVariable)type, srcType, declaringClass);
        }
        if (type instanceof ParameterizedType) {
            return GenericTypeResolver.resolveParameterizedType((ParameterizedType)type, srcType, declaringClass);
        }
        if (type instanceof GenericArrayType) {
            return GenericTypeResolver.resolveGenericArrayType((GenericArrayType)type, srcType, declaringClass);
        }
        return type;
    }

    private static Type resolveGenericArrayType(GenericArrayType genericArrayType, Type srcType, Class<?> declaringClass) {
        Type componentType = genericArrayType.getGenericComponentType();
        Type resolvedComponentType = null;
        if (componentType instanceof TypeVariable) {
            resolvedComponentType = GenericTypeResolver.resolveTypeVar((TypeVariable)componentType, srcType, declaringClass);
        } else if (componentType instanceof GenericArrayType) {
            resolvedComponentType = GenericTypeResolver.resolveGenericArrayType((GenericArrayType)componentType, srcType, declaringClass);
        } else if (componentType instanceof ParameterizedType) {
            resolvedComponentType = GenericTypeResolver.resolveParameterizedType((ParameterizedType)componentType, srcType, declaringClass);
        }
        if (resolvedComponentType instanceof Class) {
            return Array.newInstance((Class)resolvedComponentType, 0).getClass();
        }
        return new GenericArrayTypes(resolvedComponentType);
    }

    private static ParameterizedType resolveParameterizedType(ParameterizedType parameterizedType, Type srcType, Class<?> declaringClass) {
        Class rawType = (Class)parameterizedType.getRawType();
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        Type[] args = new Type[typeArgs.length];
        for (int i = 0; i < typeArgs.length; ++i) {
            args[i] = typeArgs[i] instanceof TypeVariable ? GenericTypeResolver.resolveTypeVar((TypeVariable)typeArgs[i], srcType, declaringClass) : (typeArgs[i] instanceof ParameterizedType ? GenericTypeResolver.resolveParameterizedType((ParameterizedType)typeArgs[i], srcType, declaringClass) : (typeArgs[i] instanceof WildcardType ? GenericTypeResolver.resolveWildcardType((WildcardType)typeArgs[i], srcType, declaringClass) : typeArgs[i]));
        }
        return new ParameterizedTypes(rawType, null, args);
    }

    private static Type resolveWildcardType(WildcardType wildcardType, Type srcType, Class<?> declaringClass) {
        Type[] lowerBounds = GenericTypeResolver.resolveWildcardTypeBounds(wildcardType.getLowerBounds(), srcType, declaringClass);
        Type[] upperBounds = GenericTypeResolver.resolveWildcardTypeBounds(wildcardType.getUpperBounds(), srcType, declaringClass);
        return new WildcardTypes(lowerBounds, upperBounds);
    }

    private static Type[] resolveWildcardTypeBounds(Type[] bounds, Type srcType, Class<?> declaringClass) {
        Type[] result = new Type[bounds.length];
        for (int i = 0; i < bounds.length; ++i) {
            result[i] = bounds[i] instanceof TypeVariable ? GenericTypeResolver.resolveTypeVar((TypeVariable)bounds[i], srcType, declaringClass) : (bounds[i] instanceof ParameterizedType ? GenericTypeResolver.resolveParameterizedType((ParameterizedType)bounds[i], srcType, declaringClass) : (bounds[i] instanceof WildcardType ? GenericTypeResolver.resolveWildcardType((WildcardType)bounds[i], srcType, declaringClass) : bounds[i]));
        }
        return result;
    }

    private static Type resolveTypeVar(TypeVariable<?> typeVar, Type srcType, Class<?> declaringClass) {
        Type[] superInterfaces;
        Class clazz;
        if (srcType instanceof Class) {
            clazz = (Class)srcType;
        } else if (srcType instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)srcType).getRawType();
        } else {
            throw new IllegalArgumentException("The 2nd arg must be Class or ParameterizedType, but was: " + String.valueOf(srcType.getClass()));
        }
        if (clazz == declaringClass) {
            Type[] bounds = typeVar.getBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
            return Object.class;
        }
        Type superclass = clazz.getGenericSuperclass();
        Type result = GenericTypeResolver.scanSuperTypes(typeVar, srcType, declaringClass, clazz, superclass);
        if (result != null) {
            return result;
        }
        for (Type superInterface : superInterfaces = clazz.getGenericInterfaces()) {
            result = GenericTypeResolver.scanSuperTypes(typeVar, srcType, declaringClass, clazz, superInterface);
            if (result == null) continue;
            return result;
        }
        return Object.class;
    }

    private static Type scanSuperTypes(TypeVariable<?> typeVar, Type srcType, Class<?> declaringClass, Class<?> clazz, Type superclass) {
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parentAsType = (ParameterizedType)superclass;
            Class parentAsClass = (Class)parentAsType.getRawType();
            TypeVariable<Class<T>>[] parentTypeVars = parentAsClass.getTypeParameters();
            if (srcType instanceof ParameterizedType) {
                parentAsType = GenericTypeResolver.translateParentTypeVars((ParameterizedType)srcType, clazz, parentAsType);
            }
            if (declaringClass == parentAsClass) {
                for (int i = 0; i < parentTypeVars.length; ++i) {
                    if (!typeVar.equals(parentTypeVars[i])) continue;
                    return parentAsType.getActualTypeArguments()[i];
                }
            }
            if (declaringClass.isAssignableFrom(parentAsClass)) {
                return GenericTypeResolver.resolveTypeVar(typeVar, parentAsType, declaringClass);
            }
        } else if (superclass instanceof Class && declaringClass.isAssignableFrom((Class)superclass)) {
            return GenericTypeResolver.resolveTypeVar(typeVar, superclass, declaringClass);
        }
        return null;
    }

    private static ParameterizedType translateParentTypeVars(ParameterizedType srcType, Class<?> srcClass, ParameterizedType parentType) {
        Type[] parentTypeArgs = parentType.getActualTypeArguments();
        Type[] srcTypeArgs = srcType.getActualTypeArguments();
        TypeVariable<Class<?>>[] srcTypeVars = srcClass.getTypeParameters();
        Type[] newParentArgs = new Type[parentTypeArgs.length];
        boolean noChange = true;
        for (int i = 0; i < parentTypeArgs.length; ++i) {
            if (parentTypeArgs[i] instanceof TypeVariable) {
                for (int j = 0; j < srcTypeVars.length; ++j) {
                    if (!srcTypeVars[j].equals(parentTypeArgs[i])) continue;
                    noChange = false;
                    newParentArgs[i] = srcTypeArgs[j];
                }
                continue;
            }
            newParentArgs[i] = parentTypeArgs[i];
        }
        return noChange ? parentType : new ParameterizedTypes((Class)parentType.getRawType(), null, newParentArgs);
    }

    public static class GenericArrayTypes
    implements GenericArrayType {
        private final Type genericComponentType;

        GenericArrayTypes(Type genericComponentType) {
            this.genericComponentType = genericComponentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }
    }

    public static class ParameterizedTypes
    implements ParameterizedType {
        private final Class<?> rawType;
        private final Type ownerType;
        private final Type[] actualTypeArguments;

        public ParameterizedTypes(Class<?> rawType, Type ownerType, Type[] actualTypeArguments) {
            this.rawType = rawType;
            this.ownerType = ownerType;
            this.actualTypeArguments = actualTypeArguments;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public String toString() {
            return "ParameterizedTypeImpl [rawType=" + String.valueOf(this.rawType) + ", ownerType=" + String.valueOf(this.ownerType) + ", actualTypeArguments=" + Arrays.toString(this.actualTypeArguments) + "]";
        }
    }

    public static class WildcardTypes
    implements WildcardType {
        private final Type[] lowerBounds;
        private final Type[] upperBounds;

        WildcardTypes(Type[] lowerBounds, Type[] upperBounds) {
            this.lowerBounds = lowerBounds;
            this.upperBounds = upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }
    }
}

