/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.miaixz.bus.core.Context;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.builder.EntityClassBuilder;
import org.miaixz.bus.mapper.builder.TableSchemaBuilder;
import org.miaixz.bus.mapper.parsing.TableMeta;
import org.miaixz.bus.mapper.provider.NamingProvider;

public class TableAnnotationBuilder
implements TableSchemaBuilder {
    @Override
    public TableMeta createTable(Class<?> entityClass, TableSchemaBuilder.Chain chain) {
        TableMeta tableMeta = chain.createTable(entityClass);
        if (tableMeta == null) {
            tableMeta = TableMeta.of(entityClass);
        }
        this.processTableAnnotations(tableMeta, entityClass);
        if (entityClass.isAnnotationPresent(Entity.class)) {
            tableMeta.autoResultMap(true);
        }
        if (StringKit.isNotEmpty((CharSequence)tableMeta.table())) {
            String prefix = Context.INSTANCE.getProperty("table.prefix", "");
            tableMeta.table(prefix + tableMeta.table());
        }
        EntityClassBuilder.setTableMeta(tableMeta);
        return tableMeta;
    }

    protected void processTableAnnotations(TableMeta tableMeta, Class<?> entityClass) {
        if (entityClass.isAnnotationPresent(Table.class)) {
            Table table = entityClass.getAnnotation(Table.class);
            if (StringKit.isNotEmpty((CharSequence)table.name())) {
                tableMeta.table(table.name());
            }
            if (StringKit.isNotEmpty((CharSequence)table.catalog())) {
                tableMeta.catalog(table.catalog());
            }
            if (StringKit.isNotEmpty((CharSequence)table.schema())) {
                tableMeta.schema(table.schema());
            }
        } else if (StringKit.isEmpty((CharSequence)tableMeta.table())) {
            tableMeta.table(NamingProvider.getDefaultStyle().tableName(entityClass));
        }
    }
}

