/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.criteria;

import java.util.Collection;
import lombok.Generated;
import org.miaixz.bus.mapper.criteria.Criteria;
import org.miaixz.bus.mapper.criteria.OrCriteria;
import org.miaixz.bus.mapper.parsing.ColumnMeta;

public class Criterion {
    private final String condition;
    private Object value;
    private Object secondValue;
    private String javaType;
    private String typeHandler;
    private boolean noValue;
    private boolean singleValue;
    private boolean betweenValue;
    private boolean listValue;
    private boolean orValue;

    public Criterion(String condition) {
        this.condition = condition;
        this.noValue = true;
    }

    protected Criterion(String condition, Object value) {
        this(condition, value, null);
    }

    public Criterion(String condition, Object value, ColumnMeta column) {
        this.condition = condition;
        this.value = value;
        if (column != null) {
            Class<?> javaTypeClass = column.javaType();
            if (javaTypeClass != null) {
                this.javaType = javaTypeClass.getName();
            }
            if (column.typeHandler() != null) {
                this.typeHandler = column.typeHandler().getName();
            }
        }
        if (value instanceof Collection) {
            if (condition != null) {
                this.listValue = true;
            } else {
                this.orValue = true;
            }
        } else {
            this.singleValue = true;
        }
    }

    protected Criterion(String condition, Object value, Object secondValue) {
        this(condition, value, secondValue, null);
    }

    protected Criterion(String condition, Object value, Object secondValue, ColumnMeta column) {
        this.condition = condition;
        this.value = value;
        this.secondValue = secondValue;
        if (column != null) {
            Class<?> javaTypeClass = column.javaType();
            if (javaTypeClass != null) {
                this.javaType = javaTypeClass.getName();
            }
            if (column.typeHandler() != null) {
                this.typeHandler = column.typeHandler().getName();
            }
        }
        this.betweenValue = true;
    }

    public String variables(String field) {
        StringBuilder variables = new StringBuilder();
        variables.append("#{").append(field);
        if (this.javaType != null && !this.javaType.isEmpty()) {
            variables.append(",javaType=").append(this.javaType);
        }
        if (this.typeHandler != null && !this.typeHandler.isEmpty()) {
            variables.append(",typeHandler=").append(this.typeHandler);
        }
        return variables.append("}").toString();
    }

    public String getCondition() {
        return this.condition;
    }

    public Object getSecondValue() {
        return this.secondValue;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isBetweenValue() {
        return this.betweenValue;
    }

    public boolean isListValue() {
        return this.listValue;
    }

    public boolean isNoValue() {
        return this.noValue;
    }

    public boolean isSingleValue() {
        return this.singleValue;
    }

    public boolean isOrValue() {
        if (this.orValue && this.value instanceof Collection) {
            return ((Collection)this.value).stream().filter(item -> item instanceof OrCriteria).map(OrCriteria.class::cast).anyMatch(Criteria::isValid);
        }
        return false;
    }

    @Generated
    protected Criterion(CriterionBuilder<?, ?> b) {
        this.condition = b.condition;
        this.value = b.value;
        this.secondValue = b.secondValue;
        this.javaType = b.javaType;
        this.typeHandler = b.typeHandler;
        this.noValue = b.noValue;
        this.singleValue = b.singleValue;
        this.betweenValue = b.betweenValue;
        this.listValue = b.listValue;
        this.orValue = b.orValue;
    }

    @Generated
    public static CriterionBuilder<?, ?> builder() {
        return new CriterionBuilderImpl();
    }

    @Generated
    public String getJavaType() {
        return this.javaType;
    }

    @Generated
    public String getTypeHandler() {
        return this.typeHandler;
    }

    @Generated
    public void setValue(Object value) {
        this.value = value;
    }

    @Generated
    public void setSecondValue(Object secondValue) {
        this.secondValue = secondValue;
    }

    @Generated
    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    @Generated
    public void setTypeHandler(String typeHandler) {
        this.typeHandler = typeHandler;
    }

    @Generated
    public void setNoValue(boolean noValue) {
        this.noValue = noValue;
    }

    @Generated
    public void setSingleValue(boolean singleValue) {
        this.singleValue = singleValue;
    }

    @Generated
    public void setBetweenValue(boolean betweenValue) {
        this.betweenValue = betweenValue;
    }

    @Generated
    public void setListValue(boolean listValue) {
        this.listValue = listValue;
    }

    @Generated
    public void setOrValue(boolean orValue) {
        this.orValue = orValue;
    }

    @Generated
    public static abstract class CriterionBuilder<C extends Criterion, B extends CriterionBuilder<C, B>> {
        @Generated
        private String condition;
        @Generated
        private Object value;
        @Generated
        private Object secondValue;
        @Generated
        private String javaType;
        @Generated
        private String typeHandler;
        @Generated
        private boolean noValue;
        @Generated
        private boolean singleValue;
        @Generated
        private boolean betweenValue;
        @Generated
        private boolean listValue;
        @Generated
        private boolean orValue;

        @Generated
        public B condition(String condition) {
            this.condition = condition;
            return this.self();
        }

        @Generated
        public B value(Object value) {
            this.value = value;
            return this.self();
        }

        @Generated
        public B secondValue(Object secondValue) {
            this.secondValue = secondValue;
            return this.self();
        }

        @Generated
        public B javaType(String javaType) {
            this.javaType = javaType;
            return this.self();
        }

        @Generated
        public B typeHandler(String typeHandler) {
            this.typeHandler = typeHandler;
            return this.self();
        }

        @Generated
        public B noValue(boolean noValue) {
            this.noValue = noValue;
            return this.self();
        }

        @Generated
        public B singleValue(boolean singleValue) {
            this.singleValue = singleValue;
            return this.self();
        }

        @Generated
        public B betweenValue(boolean betweenValue) {
            this.betweenValue = betweenValue;
            return this.self();
        }

        @Generated
        public B listValue(boolean listValue) {
            this.listValue = listValue;
            return this.self();
        }

        @Generated
        public B orValue(boolean orValue) {
            this.orValue = orValue;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Criterion.CriterionBuilder(condition=" + this.condition + ", value=" + String.valueOf(this.value) + ", secondValue=" + String.valueOf(this.secondValue) + ", javaType=" + this.javaType + ", typeHandler=" + this.typeHandler + ", noValue=" + this.noValue + ", singleValue=" + this.singleValue + ", betweenValue=" + this.betweenValue + ", listValue=" + this.listValue + ", orValue=" + this.orValue + ")";
        }
    }

    @Generated
    private static final class CriterionBuilderImpl
    extends CriterionBuilder<Criterion, CriterionBuilderImpl> {
        @Generated
        private CriterionBuilderImpl() {
        }

        @Override
        @Generated
        protected CriterionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Criterion build() {
            return new Criterion(this);
        }
    }
}

