/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.handler;

import java.sql.Connection;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.miaixz.bus.core.data.id.ID;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.Context;
import org.miaixz.bus.mapper.handler.AbstractSqlHandler;
import org.miaixz.bus.mapper.handler.MapperHandler;

@Intercepts(value={@Signature(type=StatementHandler.class, method="getBoundSql", args={}), @Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class}), @Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class MybatisInterceptor
extends AbstractSqlHandler
implements Interceptor {
    private final Set<MapperHandler> handlers = new HashSet<MapperHandler>();

    public Object intercept(Invocation invocation) throws Throwable {
        MetaObject metaObject;
        long start = DateKit.current();
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        if (target instanceof Executor) {
            Object result = this.handleExecutor((Executor)target, args, invocation);
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args.length > 1 ? args[1] : null;
            BoundSql boundSql = ms.getBoundSql(parameter);
            this.logging(ms, boundSql, start);
            return result;
        }
        if (target instanceof StatementHandler) {
            Object result = this.handleStatementHandler((StatementHandler)target, args, invocation);
            MetaObject metaObject2 = MybatisInterceptor.getMetaObject(target);
            MappedStatement ms = MybatisInterceptor.getMappedStatement(metaObject2);
            BoundSql boundSql = (BoundSql)metaObject2.getValue("delegate.boundSql");
            this.logging(ms, boundSql, start);
            return result;
        }
        Object result = invocation.proceed();
        MetaObject metaObject3 = metaObject = args != null && args.length > 0 && args[0] instanceof MappedStatement ? MybatisInterceptor.getMetaObject(args[0]) : null;
        if (metaObject != null) {
            MappedStatement ms = MybatisInterceptor.getMappedStatement(metaObject);
            BoundSql boundSql = ms.getBoundSql(args.length > 1 ? args[1] : null);
            this.logging(ms, boundSql, start);
        }
        return result;
    }

    private Object handleExecutor(Executor executor, Object[] args, Invocation invocation) throws Throwable {
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        SqlCommandType commandType = ms.getSqlCommandType();
        if (commandType == SqlCommandType.SELECT) {
            return this.processQuery(executor, ms, parameter, args, invocation);
        }
        if (commandType == SqlCommandType.INSERT || commandType == SqlCommandType.UPDATE || commandType == SqlCommandType.DELETE) {
            return this.processUpdate(executor, ms, parameter, invocation);
        }
        return invocation.proceed();
    }

    private Object handleStatementHandler(StatementHandler statementHandler, Object[] args, Invocation invocation) throws Throwable {
        if (args == null) {
            this.handlers.forEach(handler -> handler.getBoundSql(statementHandler));
        } else {
            this.handlers.forEach(handler -> handler.prepare(statementHandler));
        }
        return invocation.proceed();
    }

    private Object processQuery(Executor executor, MappedStatement ms, Object parameter, Object[] args, Invocation invocation) throws Throwable {
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        BoundSql boundSql = args.length == 4 ? ms.getBoundSql(parameter) : (BoundSql)args[5];
        CacheKey cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        for (MapperHandler handler : this.handlers) {
            if (!handler.isQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql)) {
                return Collections.emptyList();
            }
            Object[] result = new Object[1];
            handler.query(result, executor, ms, parameter, rowBounds, resultHandler, boundSql);
            if (!ArrayKit.isNotEmpty((Object)result[0])) continue;
            return result[0];
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    private Object processUpdate(Executor executor, MappedStatement ms, Object parameter, Invocation invocation) throws Throwable {
        for (MapperHandler handler : this.handlers) {
            if (!handler.isUpdate(executor, ms, parameter)) {
                return -1;
            }
            handler.update(executor, ms, parameter);
        }
        return invocation.proceed();
    }

    private void logging(MappedStatement ms, BoundSql boundSql, long start) {
        long duration = DateKit.current() - start;
        Logger.debug((String)"==>     Method: {} {}ms", (Object[])new Object[]{ms.getId(), duration});
        String sql = this.format(ms.getConfiguration(), boundSql);
        Logger.debug((String)"==>     Script: {}", (Object[])new Object[]{sql});
    }

    private String format(Configuration configuration, BoundSql boundSql) {
        String id = ID.objectId();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ").replaceAll("\\?", id);
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        if (CollKit.isEmpty((Collection)parameterMappings) || parameterObject == null) {
            return sql;
        }
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
            return sql.replaceFirst(id, Matcher.quoteReplacement(MybatisInterceptor.getParameterValue(parameterObject)));
        }
        MetaObject metaObject = configuration.newMetaObject(parameterObject);
        for (ParameterMapping mapping : parameterMappings) {
            String propertyName = mapping.getProperty();
            if (metaObject.hasGetter(propertyName)) {
                sql = sql.replaceFirst(id, Matcher.quoteReplacement(MybatisInterceptor.getParameterValue(metaObject.getValue(propertyName))));
                continue;
            }
            if (boundSql.hasAdditionalParameter(propertyName)) {
                sql = sql.replaceFirst(id, Matcher.quoteReplacement(MybatisInterceptor.getParameterValue(boundSql.getAdditionalParameter(propertyName))));
                continue;
            }
            sql = sql.replaceFirst(id, "Missing");
        }
        return sql;
    }

    private static String getParameterValue(Object object) {
        if (object instanceof String) {
            return "'" + String.valueOf(object) + "'";
        }
        if (object instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            return "'" + formatter.format(object) + "'";
        }
        return object != null ? object.toString() : "";
    }

    public Object plugin(Object target) {
        return target instanceof Executor || target instanceof StatementHandler || target instanceof ResultSetHandler ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }

    public void addHandler(MapperHandler handler) {
        this.handlers.add(handler);
    }

    public void setHandlers(List<MapperHandler> handlers) {
        this.handlers.clear();
        if (handlers != null) {
            this.handlers.addAll(handlers);
        }
    }

    public List<MapperHandler> getHandlers() {
        return new ArrayList<MapperHandler>(this.handlers);
    }

    public void setProperties(Properties properties) {
        Context context = (Context)Context.newInstance((Properties)properties);
        Map groups = context.group("@");
        groups.forEach((key, value) -> {
            MapperHandler handler = (MapperHandler)ReflectKit.newInstance((String)key);
            this.addHandler(handler);
        });
    }
}

