/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.util.Objects;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.Args;
import org.miaixz.bus.mapper.parsing.FieldMeta;
import org.miaixz.bus.mapper.parsing.PropertyMeta;
import org.miaixz.bus.mapper.parsing.TableMeta;
import org.miaixz.bus.mapper.support.keysql.GenId;

public class ColumnMeta
extends PropertyMeta<ColumnMeta> {
    protected final FieldMeta fieldMeta;
    protected TableMeta tableMeta;
    protected String column;
    protected boolean id;
    protected boolean nullable;
    protected boolean useGeneratedKeys;
    protected String afterSql;
    protected Class<? extends GenId> genId;
    protected boolean genIdExecuteBefore;
    protected String orderBy;
    protected int orderByPriority;
    protected boolean selectable = true;
    protected boolean insertable = true;
    protected boolean updatable = true;
    protected JdbcType jdbcType;
    protected Class<? extends TypeHandler> typeHandler;
    protected String numericScale;

    protected ColumnMeta(FieldMeta fieldMeta) {
        this.fieldMeta = fieldMeta;
    }

    public static ColumnMeta of(FieldMeta field) {
        return new ColumnMeta(field);
    }

    public ColumnMeta tableMeta(TableMeta entityTable) {
        this.tableMeta = entityTable;
        return this;
    }

    public ColumnMeta column(String column) {
        this.column = column;
        return this;
    }

    public ColumnMeta id(boolean id) {
        this.id = id;
        return this;
    }

    public ColumnMeta nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public ColumnMeta useGeneratedKeys(boolean useGeneratedKeys) {
        this.useGeneratedKeys = useGeneratedKeys;
        return this;
    }

    public ColumnMeta afterSql(String afterSql) {
        this.afterSql = afterSql;
        return this;
    }

    public ColumnMeta genId(Class<? extends GenId> genId) {
        this.genId = genId;
        return this;
    }

    public ColumnMeta genIdExecuteBefore(boolean genIdExecuteBefore) {
        this.genIdExecuteBefore = genIdExecuteBefore;
        return this;
    }

    public ColumnMeta orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public ColumnMeta orderByPriority(int orderByPriority) {
        this.orderByPriority = orderByPriority;
        return this;
    }

    public ColumnMeta selectable(boolean selectable) {
        this.selectable = selectable;
        return this;
    }

    public ColumnMeta insertable(boolean insertable) {
        this.insertable = insertable;
        return this;
    }

    public ColumnMeta updatable(boolean updatable) {
        this.updatable = updatable;
        return this;
    }

    public ColumnMeta jdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
        return this;
    }

    public ColumnMeta typeHandler(Class<? extends TypeHandler> typeHandler) {
        this.typeHandler = typeHandler;
        return this;
    }

    public ColumnMeta numericScale(String numericScale) {
        this.numericScale = numericScale;
        return this;
    }

    public Class<?> javaType() {
        return this.fieldMeta().getType();
    }

    public String property() {
        return this.property("");
    }

    public String property(String prefix) {
        return prefix + this.fieldMeta().getName();
    }

    public String variables() {
        return this.variables("");
    }

    public String variables(String prefix) {
        return "#{" + this.property(prefix) + (String)this.jdbcTypeVariables().orElse((Object)"") + (String)this.javaTypeVariables().orElse((Object)"") + (String)this.typeHandlerVariables().orElse((Object)"") + (String)this.numericScaleVariables().orElse((Object)"") + "}";
    }

    public Optional<String> javaTypeVariables() {
        Class<?> javaType = this.javaType();
        if (javaType != null) {
            return Optional.of((Object)(", javaType=" + javaType.getName()));
        }
        return Optional.empty();
    }

    public Optional<String> jdbcTypeVariables() {
        if (this.jdbcType != null && this.jdbcType != JdbcType.UNDEFINED) {
            return Optional.of((Object)(", jdbcType=" + String.valueOf(this.jdbcType)));
        }
        return Optional.empty();
    }

    public Optional<String> typeHandlerVariables() {
        if (this.typeHandler != null && this.typeHandler != UnknownTypeHandler.class) {
            return Optional.of((Object)(", typeHandler=" + this.typeHandler.getName()));
        }
        return Optional.empty();
    }

    public Optional<String> numericScaleVariables() {
        if (StringKit.isNotEmpty((CharSequence)this.numericScale)) {
            return Optional.of((Object)(", numericScale=" + this.numericScale));
        }
        return Optional.empty();
    }

    public String columnAsProperty() {
        return this.columnAsProperty("");
    }

    public String columnAsProperty(String prefix) {
        String column = this.column();
        Matcher matcher = Args.DELIMITER.matcher(this.column());
        if (matcher.find()) {
            column = matcher.group(1);
        }
        if (!Objects.equals(column, this.property(prefix))) {
            return this.column() + " AS " + this.property(prefix);
        }
        return this.column();
    }

    public String columnEqualsProperty() {
        return this.columnEqualsProperty("");
    }

    public String columnEqualsProperty(String prefix) {
        return this.column() + " = " + this.variables(prefix);
    }

    public String notNullTest() {
        return this.notNullTest("");
    }

    public String notNullTest(String prefix) {
        return this.property(prefix) + " != null";
    }

    public String notEmptyTest() {
        return this.notEmptyTest("");
    }

    public String notEmptyTest(String prefix) {
        if (this.fieldMeta().getType() == String.class) {
            return this.notNullTest(prefix) + " and " + this.property(prefix) + " != '' ";
        }
        return this.notNullTest();
    }

    public boolean hasPrimaryKeyStrategy() {
        return this.id && (this.useGeneratedKeys || this.afterSql != null && !this.afterSql.isEmpty() || this.genId != null && this.genId != GenId.NULL.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnMeta)) {
            return false;
        }
        ColumnMeta that = (ColumnMeta)o;
        return this.column().equals(that.column());
    }

    public int hashCode() {
        return Objects.hash(this.column());
    }

    public String toString() {
        return this.columnEqualsProperty();
    }

    @Generated
    public FieldMeta fieldMeta() {
        return this.fieldMeta;
    }

    @Generated
    public TableMeta tableMeta() {
        return this.tableMeta;
    }

    @Generated
    public String column() {
        return this.column;
    }

    @Generated
    public boolean id() {
        return this.id;
    }

    @Generated
    public boolean nullable() {
        return this.nullable;
    }

    @Generated
    public boolean useGeneratedKeys() {
        return this.useGeneratedKeys;
    }

    @Generated
    public String afterSql() {
        return this.afterSql;
    }

    @Generated
    public Class<? extends GenId> genId() {
        return this.genId;
    }

    @Generated
    public boolean genIdExecuteBefore() {
        return this.genIdExecuteBefore;
    }

    @Generated
    public String orderBy() {
        return this.orderBy;
    }

    @Generated
    public int orderByPriority() {
        return this.orderByPriority;
    }

    @Generated
    public boolean selectable() {
        return this.selectable;
    }

    @Generated
    public boolean insertable() {
        return this.insertable;
    }

    @Generated
    public boolean updatable() {
        return this.updatable;
    }

    @Generated
    public JdbcType jdbcType() {
        return this.jdbcType;
    }

    @Generated
    public Class<? extends TypeHandler> typeHandler() {
        return this.typeHandler;
    }

    @Generated
    public String numericScale() {
        return this.numericScale;
    }
}

