/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.mapper.Holder;
import org.miaixz.bus.mapper.builder.ClassMetaResolver;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.FieldMeta;
import org.miaixz.bus.mapper.parsing.TableMeta;

public abstract class MapperFactory {
    public static TableMeta create(Class<?> mapperType, Method mapperMethod) {
        Optional<Class<?>> optionalClass = ClassMetaResolver.find(mapperType, mapperMethod);
        if (optionalClass.isPresent()) {
            return MapperFactory.create((Class)optionalClass.getOrNull());
        }
        throw new RuntimeException("Can't obtain " + (mapperMethod != null ? mapperMethod.getName() + " method" : mapperType.getSimpleName() + " interface") + " corresponding entity class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMeta create(Class<?> entityClass) {
        TableMeta tableMeta = Holder.TABLE_SCHEMA_CHAIN.createTable(entityClass);
        if (tableMeta == null) {
            throw new NullPointerException("Unable to get " + entityClass.getName() + " entity class information");
        }
        if (!tableMeta.ready()) {
            Class<?> clazz = entityClass;
            synchronized (clazz) {
                if (!tableMeta.ready()) {
                    Class<?> declaredClass = entityClass;
                    boolean isSuperclass = false;
                    while (declaredClass != null && declaredClass != Object.class) {
                        Object[] declaredFields = declaredClass.getDeclaredFields();
                        if (isSuperclass) {
                            MapperFactory.reverse(declaredFields);
                        }
                        for (Object field : declaredFields) {
                            FieldMeta fieldMeta;
                            int modifiers = ((Field)field).getModifiers();
                            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || tableMeta.isExcludeField(fieldMeta = new FieldMeta(entityClass, (Field)field))) continue;
                            Optional<List<ColumnMeta>> optionalEntityColumns = Holder.COLUMN_SCHEMA_CHAIN.createColumn(tableMeta, fieldMeta);
                            optionalEntityColumns.ifPresent((ConsumerX & Serializable)columns -> columns.forEach(tableMeta::addColumn));
                        }
                        for (declaredClass = declaredClass.getSuperclass(); tableMeta.isExcludeSuperClass(declaredClass) && declaredClass != Object.class; declaredClass = declaredClass.getSuperclass()) {
                        }
                        isSuperclass = true;
                    }
                    tableMeta.ready(true);
                }
            }
        }
        return tableMeta;
    }

    protected static void reverse(Object[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            Object temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
    }
}

