/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.miaixz.bus.core.Context;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.xyz.BooleanKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class PropertyMeta<T extends PropertyMeta> {
    protected Map<String, String> props;

    public String getProp(String key) {
        String val;
        if (key == null || key.isEmpty()) {
            return null;
        }
        String string = val = this.props != null ? this.props.get(key) : null;
        if (val == null) {
            val = Context.INSTANCE.getProperty(key);
        }
        return val;
    }

    public String getProp(String key, String defaultValue) {
        return (String)ObjectKit.defaultIfNull((Object)this.getProp(key), (Object)defaultValue);
    }

    public Integer getInt(String prop) {
        return Convert.toInt((Object)this.getProp(prop));
    }

    public Integer getInt(String key, Integer defaultValue) {
        return Convert.toInt((Object)this.getInt(key), (Integer)defaultValue);
    }

    public Boolean getBoolean(String key) {
        return BooleanKit.toBoolean((String)this.getProp(key));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.getProp(key);
        if (value == null) {
            return defaultValue;
        }
        return BooleanKit.toBoolean((String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T put(String prop, String value) {
        if (this.props == null) {
            PropertyMeta propertyMeta = this;
            synchronized (propertyMeta) {
                if (this.props == null) {
                    this.props = new ConcurrentHashMap<String, String>();
                }
            }
        }
        this.props.put(prop, value);
        return (T)this;
    }

    public T put(Map<String, String> props) {
        if (props != null && !props.isEmpty()) {
            for (Map.Entry<String, String> entry : props.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        return (T)this;
    }

    public String remove(String prop) {
        if (this.props != null) {
            String value = this.getProp(prop);
            this.props.remove(prop);
            return value;
        }
        return null;
    }

    @Generated
    public Map<String, String> props() {
        return this.props;
    }

    @Generated
    public PropertyMeta<T> props(Map<String, String> props) {
        this.props = props;
        return this;
    }
}

