/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.mapper.builder.ClassMetaResolver;
import org.miaixz.bus.mapper.builder.GenericTypeResolver;

public abstract class SchemaTypeParser
implements ClassMetaResolver {
    @Override
    public Optional<Class<?>> findClass(Class<?> mapperType, Method mapperMethod) {
        if (mapperMethod != null) {
            Optional<Class<?>> optionalClass = this.getClassByMapperMethodReturnType(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            optionalClass = this.getClassByMapperMethodParamTypes(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            optionalClass = this.getClassByMapperMethodAndMapperType(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
        }
        return this.getClassByMapperType(mapperType);
    }

    protected Optional<Class<?>> getClassByMapperMethodReturnType(Class<?> mapperType, Method mapperMethod) {
        Class<?> returnType = GenericTypeResolver.getReturnType(mapperMethod, mapperType);
        return this.isClass(returnType) ? Optional.of(returnType) : Optional.empty();
    }

    protected Optional<Class<?>> getClassByMapperMethodParamTypes(Class<?> mapperType, Method mapperMethod) {
        return this.getClassByTypes(GenericTypeResolver.resolveParamTypes(mapperMethod, mapperType));
    }

    protected Optional<Class<?>> getClassByMapperMethodAndMapperType(Class<?> mapperType, Method mapperMethod) {
        return this.getClassByTypes(GenericTypeResolver.resolveMapperTypes(mapperMethod, mapperType));
    }

    protected Optional<Class<?>> getClassByMapperType(Class<?> mapperType) {
        return this.getClassByTypes(GenericTypeResolver.resolveMapperTypes(mapperType));
    }

    protected Optional<Class<?>> getClassByType(Type type) {
        if (type instanceof Class) {
            return Optional.of((Object)((Class)type));
        }
        if (type instanceof GenericTypeResolver.ParameterizedTypes) {
            return this.getClassByTypes(((GenericTypeResolver.ParameterizedTypes)type).getActualTypeArguments());
        }
        if (type instanceof GenericTypeResolver.WildcardTypes) {
            Optional<Class<?>> optionalClass = this.getClassByTypes(((GenericTypeResolver.WildcardTypes)type).getLowerBounds());
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            return this.getClassByTypes(((GenericTypeResolver.WildcardTypes)type).getUpperBounds());
        }
        if (type instanceof GenericTypeResolver.GenericArrayTypes) {
            return this.getClassByType(((GenericTypeResolver.GenericArrayTypes)type).getGenericComponentType());
        }
        return Optional.empty();
    }

    protected Optional<Class<?>> getClassByTypes(Type[] types) {
        for (Type type : types) {
            Optional<Class<?>> optionalClass = this.getClassByType(type);
            if (!optionalClass.isPresent() || !this.isClass((Class)optionalClass.getOrNull())) continue;
            return optionalClass;
        }
        return Optional.empty();
    }
}

