/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.util.function.Supplier;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.miaixz.bus.mapper.Caching;
import org.miaixz.bus.mapper.parsing.EasySqlScript;
import org.miaixz.bus.mapper.parsing.MapperFactory;
import org.miaixz.bus.mapper.parsing.SqlScriptWrapper;
import org.miaixz.bus.mapper.parsing.TableMeta;

public interface SqlScript {
    public static String caching(ProviderContext providerContext, SqlScript sqlScript) {
        TableMeta entity = MapperFactory.create(providerContext.getMapperType(), providerContext.getMapperMethod());
        return Caching.cache(providerContext, entity, () -> String.format("<script>\n%s\n</script>", SqlScriptWrapper.wrapSqlScript(providerContext, entity, sqlScript).getSql(entity)));
    }

    public static String caching(ProviderContext providerContext, EasySqlScript sqlScript) {
        TableMeta entity = MapperFactory.create(providerContext.getMapperType(), providerContext.getMapperMethod());
        return Caching.cache(providerContext, entity, () -> String.format("<script>\n%s\n</script>", SqlScriptWrapper.wrapSqlScript(providerContext, entity, sqlScript).getSql(entity)));
    }

    default public String where(LRSupplier content) {
        return String.format("\n<where>%s\n</where> ", content.getWithLR());
    }

    public String getSql(TableMeta var1);

    default public String choose(LRSupplier content) {
        return String.format("\n<choose>%s\n</choose> ", content.getWithLR());
    }

    default public String otherwise(LRSupplier content) {
        return String.format("\n<otherwise>%s\n</otherwise> ", content.getWithLR());
    }

    default public String set(LRSupplier content) {
        return String.format("\n<set>%s\n</set> ", content.getWithLR());
    }

    default public String ifTest(String test, LRSupplier content) {
        return String.format("<if test=\"%s\">%s\n</if> ", test, content.getWithLR());
    }

    default public String ifParameterNotNull(LRSupplier content) {
        return String.format("<if test=\"_parameter != null\">%s\n</if> ", content.getWithLR());
    }

    default public String parameterNotNull(String message) {
        return this.variableNotNull("_parameter", message);
    }

    default public String variableIsTrue(String variable, String message) {
        return "\n${@org.miaixz.bus.core.lang.Assert@isTrue(" + variable + ", '" + message + "')}\n";
    }

    default public String variableIsFalse(String variable, String message) {
        return "\n${@org.miaixz.bus.core.lang.Assert@isFalse(" + variable + ", '" + message + "')}\n";
    }

    default public String variableNotNull(String variable, String message) {
        return "\n${@org.miaixz.bus.core.lang.Assert@notNull(" + variable + ", '" + message + "')}\n";
    }

    default public String variableNotEmpty(String variable, String message) {
        return "\n${@org.miaixz.bus.core.lang.Assert@notEmpty(" + variable + ", '" + message + "')}\n";
    }

    default public String whenTest(String test, LRSupplier content) {
        return String.format("\n<when test=\"%s\">%s\n</when> ", test, content.getWithLR());
    }

    default public String trim(String prefix, String suffix, String prefixOverrides, String suffixOverrides, LRSupplier content) {
        return String.format("\n<trim prefix=\"%s\" prefixOverrides=\"%s\" suffixOverrides=\"%s\" suffix=\"%s\">%s\n</trim> ", prefix, prefixOverrides, suffixOverrides, suffix, content.getWithLR());
    }

    default public String trimPrefixOverrides(String prefix, String suffix, String prefixOverrides, LRSupplier content) {
        return String.format("\n<trim prefix=\"%s\" prefixOverrides=\"%s\" suffix=\"%s\">%s\n</trim> ", prefix, prefixOverrides, suffix, content.getWithLR());
    }

    default public String trimSuffixOverrides(String prefix, String suffix, String suffixOverrides, LRSupplier content) {
        return String.format("\n<trim prefix=\"%s\" suffixOverrides=\"%s\" suffix=\"%s\">%s\n</trim> ", prefix, suffixOverrides, suffix, content.getWithLR());
    }

    default public String foreach(String collection, String item, LRSupplier content) {
        return String.format("\n<foreach collection=\"%s\" item=\"%s\">%s\n</foreach> ", collection, item, content.getWithLR());
    }

    default public String foreach(String collection, String item, String separator, LRSupplier content) {
        return String.format("\n<foreach collection=\"%s\" item=\"%s\" separator=\"%s\">%s\n</foreach> ", collection, item, separator, content.getWithLR());
    }

    default public String foreach(String collection, String item, String separator, String open, String close, LRSupplier content) {
        return String.format("\n<foreach collection=\"%s\" item=\"%s\" open=\"%s\" close=\"%s\" separator=\"%s\">%s\n</foreach> ", collection, item, open, close, separator, content.getWithLR());
    }

    default public String foreach(String collection, String item, String separator, String open, String close, String index, LRSupplier content) {
        return String.format("\n<foreach collection=\"%s\" item=\"%s\" index=\"%s\" open=\"%s\" close=\"%s\" separator=\"%s\">%s\n</foreach> ", collection, item, index, open, close, separator, content.getWithLR());
    }

    default public String bind(String name, String value) {
        return String.format("\n<bind name=\"%s\" value=\"%s\"/>", name, value);
    }

    public static interface LRSupplier
    extends Supplier<String> {
        default public String getWithLR() {
            String txt = (String)this.get();
            if (!txt.isEmpty() && txt.charAt(0) == "\n".charAt(0)) {
                return txt;
            }
            return "\n" + txt;
        }
    }
}

