/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.parsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TableNameParser {
    private static final String TOKEN_SET = "set";
    private static final String TOKEN_OF = "of";
    private static final String TOKEN_DUAL = "dual";
    private static final String IGNORE = "ignore";
    private static final String TOKEN_DELETE = "delete";
    private static final String TOKEN_UPDATE = "update";
    private static final String TOKEN_CREATE = "create";
    private static final String TOKEN_INDEX = "index";
    private static final String KEYWORD_JOIN = "join";
    private static final String KEYWORD_INTO = "into";
    private static final String KEYWORD_TABLE = "table";
    private static final String KEYWORD_FROM = "from";
    private static final String KEYWORD_USING = "using";
    private static final String KEYWORD_UPDATE = "update";
    private static final String KEYWORD_STRAIGHT_JOIN = "straight_join";
    private static final String KEYWORD_DUPLICATE = "duplicate";
    private static final List<String> concerned = Arrays.asList("table", "into", "join", "using", "update", "straight_join");
    private static final List<String> ignored = Arrays.asList("{", "set", "of", "dual");
    private static final Set<String> INDEX_TYPES = new HashSet<String>(Arrays.asList("UNIQUE", "FULLTEXT", "SPATIAL", "CLUSTERED", "NONCLUSTERED"));
    private static final Pattern NON_SQL_TOKEN_PATTERN = Pattern.compile("(--[^\\v]+)|;|(\\s+)|((?s)/[*].*?[*]/)|(((\\b|\\B)(?=[,()]))|((?<=[,()])(\\b|\\B)))");
    private final List<SqlToken> tokens;

    public TableNameParser(String sql) {
        this.tokens = this.fetchAllTokens(sql);
    }

    public void accept(TableNameVisitor visitor) {
        int index = 0;
        String first = this.tokens.get(index).getValue();
        if (TableNameParser.isOracleSpecialDelete(first, this.tokens, index)) {
            TableNameParser.visitNameToken(this.safeGetToken(index + 1), visitor);
        } else if (this.isCreateIndex(first, this.tokens, index)) {
            String value = this.tokens.get(index + 4).getValue();
            if ("ON".equalsIgnoreCase(value)) {
                TableNameParser.visitNameToken(this.safeGetToken(index + 5), visitor);
            } else {
                TableNameParser.visitNameToken(this.safeGetToken(index + 4), visitor);
            }
        } else if (this.isCreateTableIfNotExist(first, this.tokens, index)) {
            TableNameParser.visitNameToken(this.safeGetToken(index + 5), visitor);
        } else {
            while (TableNameParser.hasMoreTokens(this.tokens, index)) {
                String current;
                if (TableNameParser.isFromToken(current = this.tokens.get(index++).getValue())) {
                    TableNameParser.processFromToken(this.tokens, index, visitor);
                    continue;
                }
                if (this.isOnDuplicateKeyUpdate(current, index)) {
                    index = this.skipDuplicateKeyUpdateIndex(index);
                    continue;
                }
                if (!concerned.contains(current.toLowerCase()) || !TableNameParser.hasMoreTokens(this.tokens, index)) continue;
                SqlToken next = this.tokens.get(index++);
                if ("update".equalsIgnoreCase(current) && IGNORE.equalsIgnoreCase(next.getValue())) {
                    next = this.tokens.get(index++);
                }
                TableNameParser.visitNameToken(next, visitor);
            }
        }
    }

    private SqlToken safeGetToken(int index) {
        return index < this.tokens.size() ? this.tokens.get(index) : null;
    }

    private List<SqlToken> fetchAllTokens(String sql) {
        ArrayList<SqlToken> tokens = new ArrayList<SqlToken>();
        Matcher matcher = NON_SQL_TOKEN_PATTERN.matcher(sql);
        int last = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start != last) {
                tokens.add(new SqlToken(last, start, sql.substring(last, start)));
            }
            last = matcher.end();
        }
        if (last != sql.length()) {
            tokens.add(new SqlToken(last, sql.length(), sql.substring(last)));
        }
        return tokens;
    }

    private static boolean isOracleSpecialDelete(String current, List<SqlToken> tokens, int index) {
        if (TOKEN_DELETE.equalsIgnoreCase(current) && TableNameParser.hasMoreTokens(tokens, index++)) {
            String next = tokens.get(index).getValue();
            return !KEYWORD_FROM.equalsIgnoreCase(next) && !"*".equals(next);
        }
        return false;
    }

    private boolean isCreateIndex(String current, List<SqlToken> tokens, int index) {
        if (TOKEN_CREATE.equalsIgnoreCase(current) && TableNameParser.hasMoreTokens(tokens, index + 4)) {
            String next = tokens.get(index + 1).getValue();
            if (INDEX_TYPES.contains(next.toUpperCase())) {
                next = tokens.get(index + 2).getValue();
            }
            return TOKEN_INDEX.equalsIgnoreCase(next);
        }
        return false;
    }

    private boolean isCreateTableIfNotExist(String current, List<SqlToken> tokens, int index) {
        if (TOKEN_CREATE.equalsIgnoreCase(current) && TableNameParser.hasMoreTokens(tokens, index + 5)) {
            StringBuilder tableIfNotExist = new StringBuilder();
            for (int i = index; i <= index + 4; ++i) {
                tableIfNotExist.append(tokens.get(i).getValue());
            }
            return "createtableifnotexists".equalsIgnoreCase(tableIfNotExist.toString());
        }
        return false;
    }

    private boolean isOnDuplicateKeyUpdate(String current, int index) {
        if (KEYWORD_DUPLICATE.equalsIgnoreCase(current) && TableNameParser.hasMoreTokens(this.tokens, index++)) {
            String next = this.tokens.get(index).getValue();
            return "update".equalsIgnoreCase(next);
        }
        return false;
    }

    private static boolean isFromToken(String currentToken) {
        return KEYWORD_FROM.equalsIgnoreCase(currentToken);
    }

    private int skipDuplicateKeyUpdateIndex(int index) {
        return index + 2;
    }

    private static void processFromToken(List<SqlToken> tokens, int index, TableNameVisitor visitor) {
        SqlToken sqlToken = tokens.get(index++);
        TableNameParser.visitNameToken(sqlToken, visitor);
        String next = null;
        if (TableNameParser.hasMoreTokens(tokens, index)) {
            next = tokens.get(index++).getValue();
        }
        if (TableNameParser.shouldProcessMultipleTables(next)) {
            TableNameParser.processNonAliasedMultiTables(tokens, index, next, visitor);
        } else {
            TableNameParser.processAliasedMultiTables(tokens, index, sqlToken, visitor);
        }
    }

    private static void processNonAliasedMultiTables(List<SqlToken> tokens, int index, String nextToken, TableNameVisitor visitor) {
        while (nextToken.equals(",")) {
            TableNameParser.visitNameToken(tokens.get(index++), visitor);
            if (!TableNameParser.hasMoreTokens(tokens, index)) break;
            nextToken = tokens.get(index++).getValue();
        }
    }

    private static void processAliasedMultiTables(List<SqlToken> tokens, int index, SqlToken current, TableNameVisitor visitor) {
        String nextNextToken = null;
        if (TableNameParser.hasMoreTokens(tokens, index)) {
            nextNextToken = tokens.get(index++).getValue();
        }
        if (TableNameParser.shouldProcessMultipleTables(nextNextToken)) {
            while (TableNameParser.hasMoreTokens(tokens, index) && nextNextToken.equals(",")) {
                if (TableNameParser.hasMoreTokens(tokens, index)) {
                    current = tokens.get(index++);
                }
                if (TableNameParser.hasMoreTokens(tokens, index)) {
                    ++index;
                }
                if (TableNameParser.hasMoreTokens(tokens, index)) {
                    nextNextToken = tokens.get(index++).getValue();
                }
                TableNameParser.visitNameToken(current, visitor);
            }
        }
    }

    private static boolean shouldProcessMultipleTables(String nextToken) {
        return nextToken != null && nextToken.equals(",");
    }

    private static boolean hasMoreTokens(List<SqlToken> tokens, int index) {
        return index < tokens.size();
    }

    private static void visitNameToken(SqlToken token, TableNameVisitor visitor) {
        String value;
        if (token != null && !ignored.contains(value = token.getValue().toLowerCase())) {
            visitor.visit(token);
        }
    }

    public Collection<String> tables() {
        HashMap tableMap = new HashMap();
        this.accept(token -> {
            String name = token.getValue();
            tableMap.putIfAbsent(name.toLowerCase(), name);
        });
        return new HashSet<String>(tableMap.values());
    }

    public static class SqlToken
    implements Comparable<SqlToken> {
        private final int start;
        private final int end;
        private final String value;

        private SqlToken(int start, int end, String value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(SqlToken o) {
            return Integer.compare(this.start, o.start);
        }

        public String toString() {
            return this.value;
        }
    }

    public static interface TableNameVisitor {
        public void visit(SqlToken var1);
    }
}

