/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.provider;

import java.util.stream.Collectors;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.SqlScript;
import org.miaixz.bus.mapper.parsing.TableMeta;

public class EntityProvider {
    public static String unsupported(ProviderContext providerContext) {
        throw new UnsupportedOperationException(providerContext.getMapperMethod().getName() + " method not available");
    }

    public static String insert(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, entity -> "INSERT INTO " + entity.tableName() + "(" + entity.insertColumnList() + ") VALUES (" + entity.insertColumns().stream().map(ColumnMeta::variables).collect(Collectors.joining(",")) + ")");
    }

    public static String insertSelective(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "INSERT INTO " + entity.tableName() + this.trimSuffixOverrides("(", ")", ",", () -> entity.insertColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> column.column() + ",")).collect(Collectors.joining("\n"))) + this.trimSuffixOverrides(" VALUES (", ")", ",", () -> entity.insertColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> column.variables() + ",")).collect(Collectors.joining("\n")));
            }
        });
    }

    public static String deleteByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, entity -> "DELETE FROM " + entity.tableName() + " WHERE " + entity.idColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(" AND ")));
    }

    public static String delete(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "DELETE FROM " + entity.tableName() + this.parameterNotNull("Parameter cannot be null") + this.where(() -> entity.columns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n")));
            }
        });
    }

    public static String updateByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "UPDATE " + entity.tableName() + " SET " + entity.updateColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(",")) + this.where(() -> entity.idColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(" AND ")));
            }
        });
    }

    public static String updateByPrimaryKeySelective(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "UPDATE " + entity.tableName() + this.set(() -> entity.updateColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> column.columnEqualsProperty() + ",")).collect(Collectors.joining("\n"))) + this.where(() -> entity.idColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(" AND ")));
            }
        });
    }

    public static String selectByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "SELECT " + entity.baseColumnAsPropertyList() + " FROM " + entity.tableName() + this.where(() -> entity.idColumns().stream().map(ColumnMeta::columnEqualsProperty).collect(Collectors.joining(" AND ")));
            }
        });
    }

    public static String select(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "SELECT " + entity.baseColumnAsPropertyList() + " FROM " + entity.tableName() + this.ifParameterNotNull(() -> this.where(() -> entity.whereColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n")))) + entity.groupByColumn().orElse("") + entity.havingColumn().orElse("") + entity.orderByColumn().orElse("");
            }
        });
    }

    public static String selectCount(ProviderContext providerContext) {
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "SELECT COUNT(*)  FROM " + entity.tableName() + "\n" + this.ifParameterNotNull(() -> this.where(() -> entity.whereColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n"))));
            }
        });
    }
}

