/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.provider;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.SqlScript;
import org.miaixz.bus.mapper.parsing.TableMeta;

public class ListProvider {
    public static String insertList(ProviderContext providerContext, @Param(value="entityList") List<?> entityList) {
        if (entityList == null || entityList.size() == 0) {
            throw new NullPointerException("Parameter cannot be empty");
        }
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                return "INSERT INTO " + entity.tableName() + "(" + entity.insertColumnList() + ") VALUES " + this.foreach("entityList", "entity", ",", () -> this.trimSuffixOverrides("(", ")", ",", () -> entity.insertColumns().stream().map(column -> column.variables("entity.")).collect(Collectors.joining(","))));
            }
        });
    }

    public static String updateList(ProviderContext providerContext, @Param(value="entityList") List<?> entityList) {
        if (entityList == null || entityList.size() == 0) {
            throw new NullPointerException("Parameter cannot be empty");
        }
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                List<ColumnMeta> idColumns = entity.idColumns();
                String sql = "UPDATE " + entity.tableName() + this.trimSuffixOverrides("SET", " ", ",", () -> entity.updateColumns().stream().map(column -> this.trimSuffixOverrides(column.column() + " = CASE ", "end, ", "", () -> this.foreach("entityList", "entity", " ", () -> "WHEN ( " + idColumns.stream().map(id -> id.columnEqualsProperty("entity.")).collect(Collectors.joining(" AND ")) + ") THEN " + column.variables("entity.")))).collect(Collectors.joining(""))) + this.where(() -> "(" + idColumns.stream().map(ColumnMeta::column).collect(Collectors.joining(",")) + ") in  (" + this.foreach("entityList", "entity", "),(", "(", ")", () -> idColumns.stream().map(id -> id.variables("entity.")).collect(Collectors.joining(","))) + ")");
                return sql;
            }
        });
    }

    public static String updateListSelective(ProviderContext providerContext, @Param(value="entityList") List<?> entityList) {
        if (entityList == null || entityList.size() == 0) {
            throw new NullPointerException("Parameter cannot be empty");
        }
        return SqlScript.caching(providerContext, new SqlScript(){

            @Override
            public String getSql(TableMeta entity) {
                List<ColumnMeta> idColumns = entity.idColumns();
                String sql = "UPDATE " + entity.tableName() + this.trimSuffixOverrides("SET", " ", ",", () -> entity.updateColumns().stream().map(column -> this.trimSuffixOverrides(column.column() + " = CASE ", "end, ", "", () -> this.foreach("entityList", "entity", " ", () -> this.choose(() -> this.whenTest(column.notNullTest("entity."), () -> "WHEN ( " + idColumns.stream().map(id -> id.columnEqualsProperty("entity.")).collect(Collectors.joining(" AND ")) + ") THEN " + column.variables("entity.")) + this.otherwise(() -> "WHEN ( " + idColumns.stream().map(id -> id.columnEqualsProperty("entity.")).collect(Collectors.joining(" AND ")) + " ) THEN " + column.column()))))).collect(Collectors.joining(""))) + this.where(() -> "(" + idColumns.stream().map(ColumnMeta::column).collect(Collectors.joining(",")) + ") in  (" + this.foreach("entityList", "entity", "),(", "(", ")", () -> idColumns.stream().map(id -> id.variables("entity.")).collect(Collectors.joining(","))) + ")");
                return sql;
            }
        });
    }
}

