/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.generic;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.notify.magic.Property;

public class GenericProperty
extends Property {
    private static final String SMTP_HOST = "mail.smtp.host";
    private static final String SMTP_PORT = "mail.smtp.port";
    private static final String SMTP_AUTH = "mail.smtp.auth";
    private static final String SMTP_TIMEOUT = "mail.smtp.timeout";
    private static final String SMTP_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    private static final String SOCKEY_FACTORY = "mail.smtp.socketFactory.class";
    private static final String SOCKEY_FACTORY_PORT = "smtp.socketFactory.port";
    private static final String SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static final String MAIL_TLS_ENABLE = "mail.smtp.starttls.enable";
    private static final String MAIL_PROTOCOL = "mail.transport.protocol";
    private static final String SPLIT_LONG_PARAMS = "mail.mime.splitlongparameters";
    private static final String MAIL_DEBUG = "mail.debug";
    private String host;
    private Integer port;
    private Boolean auth;
    private String user;
    private String pass;
    private boolean debug;
    private Charset charset;
    private boolean splitlongparameters;
    private boolean startttlsEnable;
    private Boolean sslEnable;
    private String socketFactoryClass = "javax.net.ssl.SSLSocketFactory";
    private boolean socketFactoryFallback;
    private int socketFactoryPort = 465;
    private long timeout;
    private long connectionTimeout;
    private String ccs;
    private String bccs;
    private String title;
    private String content;
    private File[] attachments;
    private boolean useGlobalSession;

    public GenericProperty defaultIfEmpty() {
        if (StringKit.isBlank((CharSequence)this.host)) {
            this.host = StringKit.format((CharSequence)"smtp.{}", (Object[])new Object[]{StringKit.subSuf((CharSequence)this.sender, (int)(this.sender.indexOf(64) + 1))});
        }
        if (StringKit.isBlank((CharSequence)this.user)) {
            this.user = StringKit.subPre((CharSequence)this.sender, (int)this.sender.indexOf(64));
        }
        if (null == this.auth) {
            this.auth = false == StringKit.isBlank((CharSequence)this.pass);
        }
        if (null == this.port) {
            this.port = null != this.sslEnable && this.sslEnable != false ? this.socketFactoryPort : 25;
        }
        if (null == this.charset) {
            this.charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        }
        return this;
    }

    public Properties getSmtpProps() {
        System.setProperty(SPLIT_LONG_PARAMS, String.valueOf(this.splitlongparameters));
        Properties p = new Properties();
        p.put(MAIL_PROTOCOL, "smtp");
        p.put(SMTP_HOST, this.host);
        p.put(SMTP_PORT, String.valueOf(this.port));
        p.put(SMTP_AUTH, String.valueOf(this.auth));
        if (this.timeout > 0L) {
            p.put(SMTP_TIMEOUT, String.valueOf(this.timeout));
        }
        if (this.connectionTimeout > 0L) {
            p.put(SMTP_CONNECTION_TIMEOUT, String.valueOf(this.connectionTimeout));
        }
        p.put(MAIL_DEBUG, String.valueOf(this.debug));
        if (this.startttlsEnable) {
            p.put(MAIL_TLS_ENABLE, String.valueOf(this.startttlsEnable));
            if (null == this.sslEnable) {
                this.sslEnable = true;
            }
        }
        if (null != this.sslEnable && this.sslEnable.booleanValue()) {
            p.put(SOCKEY_FACTORY, this.socketFactoryClass);
            p.put(SOCKET_FACTORY_FALLBACK, String.valueOf(this.socketFactoryFallback));
            p.put(SOCKEY_FACTORY_PORT, String.valueOf(this.socketFactoryPort));
        }
        return p;
    }

    protected GenericProperty(GenericPropertyBuilder<?, ?> b) {
        super(b);
        this.host = b.host;
        this.port = b.port;
        this.auth = b.auth;
        this.user = b.user;
        this.pass = b.pass;
        this.debug = b.debug;
        this.charset = b.charset;
        this.splitlongparameters = b.splitlongparameters;
        this.startttlsEnable = b.startttlsEnable;
        this.sslEnable = b.sslEnable;
        this.socketFactoryClass = b.socketFactoryClass;
        this.socketFactoryFallback = b.socketFactoryFallback;
        this.socketFactoryPort = b.socketFactoryPort;
        this.timeout = b.timeout;
        this.connectionTimeout = b.connectionTimeout;
        this.ccs = b.ccs;
        this.bccs = b.bccs;
        this.title = b.title;
        this.content = b.content;
        this.attachments = b.attachments;
        this.useGlobalSession = b.useGlobalSession;
    }

    public static GenericPropertyBuilder<?, ?> builder() {
        return new GenericPropertyBuilderImpl();
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Boolean getAuth() {
        return this.auth;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isSplitlongparameters() {
        return this.splitlongparameters;
    }

    public boolean isStartttlsEnable() {
        return this.startttlsEnable;
    }

    public Boolean getSslEnable() {
        return this.sslEnable;
    }

    public String getSocketFactoryClass() {
        return this.socketFactoryClass;
    }

    public boolean isSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    public int getSocketFactoryPort() {
        return this.socketFactoryPort;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getCcs() {
        return this.ccs;
    }

    public String getBccs() {
        return this.bccs;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public File[] getAttachments() {
        return this.attachments;
    }

    public boolean isUseGlobalSession() {
        return this.useGlobalSession;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setSplitlongparameters(boolean splitlongparameters) {
        this.splitlongparameters = splitlongparameters;
    }

    public void setStartttlsEnable(boolean startttlsEnable) {
        this.startttlsEnable = startttlsEnable;
    }

    public void setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    public void setSocketFactoryClass(String socketFactoryClass) {
        this.socketFactoryClass = socketFactoryClass;
    }

    public void setSocketFactoryFallback(boolean socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
    }

    public void setSocketFactoryPort(int socketFactoryPort) {
        this.socketFactoryPort = socketFactoryPort;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setCcs(String ccs) {
        this.ccs = ccs;
    }

    public void setBccs(String bccs) {
        this.bccs = bccs;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    public void setAttachments(File[] attachments) {
        this.attachments = attachments;
    }

    public void setUseGlobalSession(boolean useGlobalSession) {
        this.useGlobalSession = useGlobalSession;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericProperty)) {
            return false;
        }
        GenericProperty other = (GenericProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isSplitlongparameters() != other.isSplitlongparameters()) {
            return false;
        }
        if (this.isStartttlsEnable() != other.isStartttlsEnable()) {
            return false;
        }
        if (this.isSocketFactoryFallback() != other.isSocketFactoryFallback()) {
            return false;
        }
        if (this.getSocketFactoryPort() != other.getSocketFactoryPort()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.isUseGlobalSession() != other.isUseGlobalSession()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$auth = this.getAuth();
        Boolean other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
            return false;
        }
        Boolean this$sslEnable = this.getSslEnable();
        Boolean other$sslEnable = other.getSslEnable();
        if (this$sslEnable == null ? other$sslEnable != null : !((Object)this$sslEnable).equals(other$sslEnable)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$pass = this.getPass();
        String other$pass = other.getPass();
        if (this$pass == null ? other$pass != null : !this$pass.equals(other$pass)) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        String this$socketFactoryClass = this.getSocketFactoryClass();
        String other$socketFactoryClass = other.getSocketFactoryClass();
        if (this$socketFactoryClass == null ? other$socketFactoryClass != null : !this$socketFactoryClass.equals(other$socketFactoryClass)) {
            return false;
        }
        String this$ccs = this.getCcs();
        String other$ccs = other.getCcs();
        if (this$ccs == null ? other$ccs != null : !this$ccs.equals(other$ccs)) {
            return false;
        }
        String this$bccs = this.getBccs();
        String other$bccs = other.getBccs();
        if (this$bccs == null ? other$bccs != null : !this$bccs.equals(other$bccs)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        return Arrays.deepEquals(this.getAttachments(), other.getAttachments());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isSplitlongparameters() ? 79 : 97);
        result = result * 59 + (this.isStartttlsEnable() ? 79 : 97);
        result = result * 59 + (this.isSocketFactoryFallback() ? 79 : 97);
        result = result * 59 + this.getSocketFactoryPort();
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        long $connectionTimeout = this.getConnectionTimeout();
        result = result * 59 + (int)($connectionTimeout >>> 32 ^ $connectionTimeout);
        result = result * 59 + (this.isUseGlobalSession() ? 79 : 97);
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
        Boolean $sslEnable = this.getSslEnable();
        result = result * 59 + ($sslEnable == null ? 43 : ((Object)$sslEnable).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $pass = this.getPass();
        result = result * 59 + ($pass == null ? 43 : $pass.hashCode());
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        String $socketFactoryClass = this.getSocketFactoryClass();
        result = result * 59 + ($socketFactoryClass == null ? 43 : $socketFactoryClass.hashCode());
        String $ccs = this.getCcs();
        result = result * 59 + ($ccs == null ? 43 : $ccs.hashCode());
        String $bccs = this.getBccs();
        result = result * 59 + ($bccs == null ? 43 : $bccs.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAttachments());
        return result;
    }

    public String toString() {
        return "GenericProperty(host=" + this.getHost() + ", port=" + this.getPort() + ", auth=" + this.getAuth() + ", user=" + this.getUser() + ", pass=" + this.getPass() + ", debug=" + this.isDebug() + ", charset=" + String.valueOf(this.getCharset()) + ", splitlongparameters=" + this.isSplitlongparameters() + ", startttlsEnable=" + this.isStartttlsEnable() + ", sslEnable=" + this.getSslEnable() + ", socketFactoryClass=" + this.getSocketFactoryClass() + ", socketFactoryFallback=" + this.isSocketFactoryFallback() + ", socketFactoryPort=" + this.getSocketFactoryPort() + ", timeout=" + this.getTimeout() + ", connectionTimeout=" + this.getConnectionTimeout() + ", ccs=" + this.getCcs() + ", bccs=" + this.getBccs() + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", attachments=" + Arrays.deepToString(this.getAttachments()) + ", useGlobalSession=" + this.isUseGlobalSession() + ")";
    }

    public static abstract class GenericPropertyBuilder<C extends GenericProperty, B extends GenericPropertyBuilder<C, B>>
    extends Property.PropertyBuilder<C, B> {
        private String host;
        private Integer port;
        private Boolean auth;
        private String user;
        private String pass;
        private boolean debug;
        private Charset charset;
        private boolean splitlongparameters;
        private boolean startttlsEnable;
        private Boolean sslEnable;
        private String socketFactoryClass;
        private boolean socketFactoryFallback;
        private int socketFactoryPort;
        private long timeout;
        private long connectionTimeout;
        private String ccs;
        private String bccs;
        private String title;
        private String content;
        private File[] attachments;
        private boolean useGlobalSession;

        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        public B port(Integer port) {
            this.port = port;
            return (B)this.self();
        }

        public B auth(Boolean auth) {
            this.auth = auth;
            return (B)this.self();
        }

        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        public B pass(String pass) {
            this.pass = pass;
            return (B)this.self();
        }

        public B debug(boolean debug) {
            this.debug = debug;
            return (B)this.self();
        }

        public B charset(Charset charset) {
            this.charset = charset;
            return (B)this.self();
        }

        public B splitlongparameters(boolean splitlongparameters) {
            this.splitlongparameters = splitlongparameters;
            return (B)this.self();
        }

        public B startttlsEnable(boolean startttlsEnable) {
            this.startttlsEnable = startttlsEnable;
            return (B)this.self();
        }

        public B sslEnable(Boolean sslEnable) {
            this.sslEnable = sslEnable;
            return (B)this.self();
        }

        public B socketFactoryClass(String socketFactoryClass) {
            this.socketFactoryClass = socketFactoryClass;
            return (B)this.self();
        }

        public B socketFactoryFallback(boolean socketFactoryFallback) {
            this.socketFactoryFallback = socketFactoryFallback;
            return (B)this.self();
        }

        public B socketFactoryPort(int socketFactoryPort) {
            this.socketFactoryPort = socketFactoryPort;
            return (B)this.self();
        }

        public B timeout(long timeout) {
            this.timeout = timeout;
            return (B)this.self();
        }

        public B connectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return (B)this.self();
        }

        public B ccs(String ccs) {
            this.ccs = ccs;
            return (B)this.self();
        }

        public B bccs(String bccs) {
            this.bccs = bccs;
            return (B)this.self();
        }

        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        @Override
        public B content(String content) {
            this.content = content;
            return (B)this.self();
        }

        public B attachments(File[] attachments) {
            this.attachments = attachments;
            return (B)this.self();
        }

        public B useGlobalSession(boolean useGlobalSession) {
            this.useGlobalSession = useGlobalSession;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "GenericProperty.GenericPropertyBuilder(super=" + super.toString() + ", host=" + this.host + ", port=" + this.port + ", auth=" + this.auth + ", user=" + this.user + ", pass=" + this.pass + ", debug=" + this.debug + ", charset=" + String.valueOf(this.charset) + ", splitlongparameters=" + this.splitlongparameters + ", startttlsEnable=" + this.startttlsEnable + ", sslEnable=" + this.sslEnable + ", socketFactoryClass=" + this.socketFactoryClass + ", socketFactoryFallback=" + this.socketFactoryFallback + ", socketFactoryPort=" + this.socketFactoryPort + ", timeout=" + this.timeout + ", connectionTimeout=" + this.connectionTimeout + ", ccs=" + this.ccs + ", bccs=" + this.bccs + ", title=" + this.title + ", content=" + this.content + ", attachments=" + Arrays.deepToString(this.attachments) + ", useGlobalSession=" + this.useGlobalSession + ")";
        }
    }

    private static final class GenericPropertyBuilderImpl
    extends GenericPropertyBuilder<GenericProperty, GenericPropertyBuilderImpl> {
        private GenericPropertyBuilderImpl() {
        }

        @Override
        protected GenericPropertyBuilderImpl self() {
            return this;
        }

        @Override
        public GenericProperty build() {
            return new GenericProperty(this);
        }
    }
}

