/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify;

public class Context {
    private String appKey;
    private String appSecret;
    private String endpoint;
    private String corpId;
    private String nonce;

    protected Context(ContextBuilder<?, ?> b) {
        this.appKey = b.appKey;
        this.appSecret = b.appSecret;
        this.endpoint = b.endpoint;
        this.corpId = b.corpId;
        this.nonce = b.nonce;
    }

    public static ContextBuilder<?, ?> builder() {
        return new ContextBuilderImpl();
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Context() {
    }

    public Context(String appKey, String appSecret, String endpoint, String corpId, String nonce) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.endpoint = endpoint;
        this.corpId = corpId;
        this.nonce = nonce;
    }

    public static abstract class ContextBuilder<C extends Context, B extends ContextBuilder<C, B>> {
        private String appKey;
        private String appSecret;
        private String endpoint;
        private String corpId;
        private String nonce;

        public B appKey(String appKey) {
            this.appKey = appKey;
            return this.self();
        }

        public B appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this.self();
        }

        public B endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this.self();
        }

        public B corpId(String corpId) {
            this.corpId = corpId;
            return this.self();
        }

        public B nonce(String nonce) {
            this.nonce = nonce;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Context.ContextBuilder(appKey=" + this.appKey + ", appSecret=" + this.appSecret + ", endpoint=" + this.endpoint + ", corpId=" + this.corpId + ", nonce=" + this.nonce + ")";
        }
    }

    private static final class ContextBuilderImpl
    extends ContextBuilder<Context, ContextBuilderImpl> {
        private ContextBuilderImpl() {
        }

        @Override
        protected ContextBuilderImpl self() {
            return this;
        }

        @Override
        public Context build() {
            return new Context(this);
        }
    }
}

