/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.unisms;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.miaixz.bus.core.basics.entity.Message;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.crypto.Builder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.AbstractProvider;
import org.miaixz.bus.notify.metric.unisms.UniMaterial;

public class UniSmsProvider
extends AbstractProvider<UniMaterial, Context> {
    public UniSmsProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(UniMaterial entity) {
        if ("".equals(entity.getTemplate()) && "".equals(entity.getTemplateName())) {
            throw new ValidateException("\u914d\u7f6e\u6587\u4ef6\u6a21\u677fid\u548c\u6a21\u677f\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap data = MapKit.newHashMap((int)4, (boolean)true);
        data.put("to", entity.getReceive());
        data.put("signature", entity.getSignature());
        data.put("templateId", entity.getTemplate());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(entity.getTemplateName(), entity.getContent());
        data.put("templateData", map);
        return this.request(entity, "sms.message.send", data);
    }

    public Message request(UniMaterial entity, String action, Map<String, Object> bodys) {
        String url;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", "uni-java-sdk/0.0.4");
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        if (entity.isSimple()) {
            url = this.getUrl(entity) + "?action=" + action + "&accessKeyId=" + this.context.getAppKey();
        } else {
            HashMap<String, Object> query = new HashMap<String, Object>();
            if (this.context.getAppSecret() != null) {
                query.put("algorithm", Algorithm.HMACSHA256);
                query.put("timestamp", System.currentTimeMillis());
                query.put("nonce", UUID.randomUUID().toString().replaceAll("-", ""));
                TreeMap<String, Object> sortedMap = new TreeMap<String, Object>();
                sortedMap.putAll(query);
                StringBuilder sb = new StringBuilder();
                for (Map.Entry stringObjectEntry : sortedMap.entrySet()) {
                    if (sb.length() > 0) {
                        sb.append('&');
                    }
                    sb.append(stringObjectEntry.getKey()).append("=").append(stringObjectEntry.getValue());
                }
                query.put("signature", Builder.hmacSha256((byte[])this.context.getAppSecret().getBytes()).digest(sb.toString()));
            }
            url = this.getUrl(entity) + "?action=" + action + "&accessKeyId=" + this.context.getAppKey() + "&algorithm=" + String.valueOf(query.get("algorithm")) + "&timestamp=" + String.valueOf(query.get("timestamp")) + "&nonce=" + String.valueOf(query.get("nonce")) + "&signature=" + String.valueOf(query.get("signature"));
        }
        String response = Httpx.post((String)url, (String)JsonKit.toJsonString(bodys), headers, (String)"application/json");
        boolean succeed = Objects.equals(JsonKit.getValue((String)response, (String)"code"), 0);
        String errcode = succeed ? ErrorCode.SUCCESS.getCode() : ErrorCode.FAILURE.getCode();
        String errmsg = succeed ? ErrorCode.SUCCESS.getDesc() : ErrorCode.FAILURE.getDesc();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }
}

