/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.upyun;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.miaixz.bus.core.basics.entity.Message;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.AbstractProvider;
import org.miaixz.bus.notify.metric.upyun.UpyunMaterial;

public class UpyunSmsProvider
extends AbstractProvider<UpyunMaterial, Context> {
    public UpyunSmsProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(UpyunMaterial entity) {
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("template_id", entity.getTemplate());
        bodys.put("mobile", entity.getReceive());
        bodys.put("vars", StringKit.split((CharSequence)entity.getParams(), (CharSequence)"|").toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", entity.getToken());
        String response = Httpx.post((String)this.getUrl(entity), bodys, headers);
        List list = JsonKit.toList((String)response, UpyunMaterial.MessageId.class);
        if (CollKit.isEmpty((Collection)list)) {
            return Message.builder().errcode(ErrorCode.FAILURE.getCode()).errmsg(ErrorCode.FAILURE.getDesc()).build();
        }
        boolean succeed = list.stream().filter(Objects::nonNull).anyMatch(UpyunMaterial.MessageId::succeed);
        String errcode = succeed ? ErrorCode.SUCCESS.getCode() : ErrorCode.FAILURE.getCode();
        String errmsg = succeed ? ErrorCode.SUCCESS.getDesc() : ErrorCode.FAILURE.getDesc();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }

    public boolean succeed(String errorCode, String msgId) {
        return StringKit.isBlank((CharSequence)errorCode) && StringKit.isNotBlank((CharSequence)msgId);
    }
}

