/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.aliyun;

import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.Material;
import org.miaixz.bus.notify.metric.aliyun.AliyunMaterial;
import org.miaixz.bus.notify.metric.aliyun.AliyunProvider;

public class AliyunEmailProvider
extends AliyunProvider<AliyunMaterial, Context> {
    public AliyunEmailProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(AliyunMaterial entity) throws InternalException {
        if (StringKit.isEmpty((CharSequence)entity.getContent())) {
            throw new InternalException("Email content cannot be empty");
        }
        if (StringKit.isEmpty((CharSequence)entity.getReceive())) {
            throw new InternalException("Email address cannot be empty");
        }
        if (StringKit.isEmpty((CharSequence)entity.getSubject())) {
            throw new InternalException("Email subject cannot be empty");
        }
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("SignatureMethod", "HMAC-SHA1");
        bodys.put("SignatureNonce", UUID.randomUUID().toString());
        bodys.put("AccessKeyId", this.context.getAppKey());
        bodys.put("SignatureVersion", "1.0");
        bodys.put("Timestamp", DateKit.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
        bodys.put("Format", "JSON");
        bodys.put("Action", "SingleSendMail");
        bodys.put("Version", "2015-11-23");
        bodys.put("RegionId", "cn-hangzhou");
        bodys.put("Subject", entity.getSubject());
        bodys.put("FromAlias", entity.getSender());
        bodys.put("ToAddress", entity.getReceive());
        if (Material.Type.HTML.equals((Object)entity.getType())) {
            bodys.put("HtmlBody", entity.getContent());
        } else if (Material.Type.TEXT.equals((Object)entity.getType())) {
            bodys.put("TextBody", entity.getContent());
        }
        bodys.put("ReplyAddress", entity.getSender());
        bodys.put("ReplyToAddress", entity.getSender());
        bodys.put("ReplyAddressAlias", entity.getSender());
        bodys.put("ClickTrace", this.getSign(bodys));
        bodys.put("Signature", this.getSign(bodys));
        HashMap<String, String> map = new HashMap<String, String>();
        for (String val : bodys.keySet()) {
            map.put(this.specialUrlEncode(val), this.specialUrlEncode((String)bodys.get(val)));
        }
        return this.checkResponse(Httpx.get((String)this.getUrl(entity), map));
    }
}

