/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.aliyun;

import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.magic.Material;
import org.miaixz.bus.notify.metric.AbstractProvider;

public class AliyunProvider<T extends Material, K extends Context>
extends AbstractProvider<T, K> {
    private static final String SUCCESS_RESULT = "OK";

    public AliyunProvider(K context) {
        super(context);
    }

    protected String specialUrlEncode(String value) {
        return URLEncoder.encode(value, Charset.UTF_8).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    protected String getSign(Map<String, String> params) {
        TreeMap<String, String> map = new TreeMap<String, String>(params);
        Iterator it = map.keySet().iterator();
        StringBuilder sortQueryStringTmp = new StringBuilder();
        while (it.hasNext()) {
            String key = (String)it.next();
            sortQueryStringTmp.append("&").append(this.specialUrlEncode(key)).append("=").append(this.specialUrlEncode(params.get(key)));
        }
        String sortedQueryString = sortQueryStringTmp.substring(1);
        String stringToSign = "GET&" + this.specialUrlEncode("/") + "&" + this.specialUrlEncode(sortedQueryString);
        return this.sign(stringToSign);
    }

    protected String sign(String stringToSign) {
        try {
            Mac mac = Mac.getInstance(Algorithm.HMACSHA1.getValue());
            mac.init(new SecretKeySpec((this.context.getAppSecret() + "&").getBytes(Charset.UTF_8), Algorithm.HMACSHA1.getValue()));
            byte[] signData = mac.doFinal(stringToSign.getBytes(Charset.UTF_8));
            return Base64.getEncoder().encodeToString(signData);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new InternalException("Aliyun specialUrlEncode error");
        }
    }

    protected Message checkResponse(String response) {
        String code = (String)JsonKit.getValue((String)response, (String)"Code");
        return Message.builder().errcode(SUCCESS_RESULT.equals(code) ? ErrorCode.SUCCESS.getCode() : code).errmsg(code).build();
    }
}

