/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.emay;

import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.crypto.Builder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.AbstractProvider;
import org.miaixz.bus.notify.metric.emay.EmayMaterial;

public class EmaySmsProvider
extends AbstractProvider<EmayMaterial, Context> {
    public EmaySmsProvider(Context context) {
        super(context);
    }

    private static Map<String, String> getParamsMap(String appId, String secretKey, String phone, String message) {
        HashMap<String, String> params = new HashMap<String, String>();
        String timestamp = DateKit.format((Date)new Date(), (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String sign = Builder.md5((String)(appId + secretKey + timestamp));
        params.put("appId", appId);
        params.put("timestamp", timestamp);
        params.put("sign", sign);
        params.put("mobiles", phone);
        params.put("content", UrlEncoder.encodeAll((String)message, (Charset)org.miaixz.bus.core.lang.Charset.UTF_8));
        return params;
    }

    @Override
    public Message send(EmayMaterial entity) {
        Map<String, String> bodys = EmaySmsProvider.getParamsMap(this.context.getAppKey(), this.context.getAppSecret(), entity.getReceive(), entity.getContent());
        HashMap headers = MapKit.newHashMap((int)1, (boolean)true);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        String response = Httpx.post((String)this.getUrl(entity), bodys, (Map)headers);
        String errcode = (String)JsonKit.getValue((String)response, (String)"errcode");
        return Message.builder().errcode(String.valueOf(200).equals(errcode) ? ErrorCode.SUCCESS.getCode() : errcode).errmsg((String)JsonKit.getValue((String)response, (String)"errmsg")).build();
    }
}

