/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.generic;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import lombok.Generated;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.notify.magic.Material;

public class GenericMaterial
extends Material {
    private static final String SMTP_HOST = "mail.smtp.host";
    private static final String SMTP_PORT = "mail.smtp.port";
    private static final String SMTP_AUTH = "mail.smtp.auth";
    private static final String SMTP_TIMEOUT = "mail.smtp.timeout";
    private static final String SMTP_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    private static final String SOCKEY_FACTORY = "mail.smtp.socketFactory.class";
    private static final String SOCKEY_FACTORY_PORT = "smtp.socketFactory.port";
    private static final String SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static final String MAIL_TLS_ENABLE = "mail.smtp.starttls.enable";
    private static final String MAIL_PROTOCOL = "mail.transport.protocol";
    private static final String SPLIT_LONG_PARAMS = "mail.mime.splitlongparameters";
    private static final String MAIL_DEBUG = "mail.debug";
    private String host;
    private Integer port;
    private Boolean auth;
    private String user;
    private String pass;
    private boolean debug;
    private Charset charset;
    private boolean splitlongparameters;
    private boolean startttlsEnable;
    private Boolean sslEnable;
    private String socketFactoryClass = "javax.net.ssl.SSLSocketFactory";
    private boolean socketFactoryFallback;
    private int socketFactoryPort = 465;
    private long timeout;
    private long connectionTimeout;
    private String ccs;
    private String bccs;
    private String title;
    private String content;
    private File[] attachments;
    private boolean useGlobalSession;

    public GenericMaterial defaultIfEmpty() {
        if (StringKit.isBlank((CharSequence)this.host)) {
            this.host = StringKit.format((CharSequence)"smtp.{}", (Object[])new Object[]{StringKit.subSuf((CharSequence)this.sender, (int)(this.sender.indexOf(64) + 1))});
        }
        if (StringKit.isBlank((CharSequence)this.user)) {
            this.user = StringKit.subPre((CharSequence)this.sender, (int)this.sender.indexOf(64));
        }
        if (null == this.auth) {
            this.auth = false == StringKit.isBlank((CharSequence)this.pass);
        }
        if (null == this.port) {
            this.port = null != this.sslEnable && this.sslEnable != false ? this.socketFactoryPort : 25;
        }
        if (null == this.charset) {
            this.charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        }
        return this;
    }

    public Properties getSmtpProps() {
        System.setProperty(SPLIT_LONG_PARAMS, String.valueOf(this.splitlongparameters));
        Properties p = new Properties();
        p.put(MAIL_PROTOCOL, "smtp");
        p.put(SMTP_HOST, this.host);
        p.put(SMTP_PORT, String.valueOf(this.port));
        p.put(SMTP_AUTH, String.valueOf(this.auth));
        if (this.timeout > 0L) {
            p.put(SMTP_TIMEOUT, String.valueOf(this.timeout));
        }
        if (this.connectionTimeout > 0L) {
            p.put(SMTP_CONNECTION_TIMEOUT, String.valueOf(this.connectionTimeout));
        }
        p.put(MAIL_DEBUG, String.valueOf(this.debug));
        if (this.startttlsEnable) {
            p.put(MAIL_TLS_ENABLE, String.valueOf(this.startttlsEnable));
            if (null == this.sslEnable) {
                this.sslEnable = true;
            }
        }
        if (null != this.sslEnable && this.sslEnable.booleanValue()) {
            p.put(SOCKEY_FACTORY, this.socketFactoryClass);
            p.put(SOCKET_FACTORY_FALLBACK, String.valueOf(this.socketFactoryFallback));
            p.put(SOCKEY_FACTORY_PORT, String.valueOf(this.socketFactoryPort));
        }
        return p;
    }

    @Generated
    protected GenericMaterial(GenericMaterialBuilder<?, ?> b) {
        super(b);
        this.host = b.host;
        this.port = b.port;
        this.auth = b.auth;
        this.user = b.user;
        this.pass = b.pass;
        this.debug = b.debug;
        this.charset = b.charset;
        this.splitlongparameters = b.splitlongparameters;
        this.startttlsEnable = b.startttlsEnable;
        this.sslEnable = b.sslEnable;
        this.socketFactoryClass = b.socketFactoryClass;
        this.socketFactoryFallback = b.socketFactoryFallback;
        this.socketFactoryPort = b.socketFactoryPort;
        this.timeout = b.timeout;
        this.connectionTimeout = b.connectionTimeout;
        this.ccs = b.ccs;
        this.bccs = b.bccs;
        this.title = b.title;
        this.content = b.content;
        this.attachments = b.attachments;
        this.useGlobalSession = b.useGlobalSession;
    }

    @Generated
    public static GenericMaterialBuilder<?, ?> builder() {
        return new GenericMaterialBuilderImpl();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Boolean getAuth() {
        return this.auth;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPass() {
        return this.pass;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }

    @Generated
    public boolean isSplitlongparameters() {
        return this.splitlongparameters;
    }

    @Generated
    public boolean isStartttlsEnable() {
        return this.startttlsEnable;
    }

    @Generated
    public Boolean getSslEnable() {
        return this.sslEnable;
    }

    @Generated
    public String getSocketFactoryClass() {
        return this.socketFactoryClass;
    }

    @Generated
    public boolean isSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    @Generated
    public int getSocketFactoryPort() {
        return this.socketFactoryPort;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public String getCcs() {
        return this.ccs;
    }

    @Generated
    public String getBccs() {
        return this.bccs;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Override
    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public File[] getAttachments() {
        return this.attachments;
    }

    @Generated
    public boolean isUseGlobalSession() {
        return this.useGlobalSession;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPass(String pass) {
        this.pass = pass;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Generated
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Generated
    public void setSplitlongparameters(boolean splitlongparameters) {
        this.splitlongparameters = splitlongparameters;
    }

    @Generated
    public void setStartttlsEnable(boolean startttlsEnable) {
        this.startttlsEnable = startttlsEnable;
    }

    @Generated
    public void setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    @Generated
    public void setSocketFactoryClass(String socketFactoryClass) {
        this.socketFactoryClass = socketFactoryClass;
    }

    @Generated
    public void setSocketFactoryFallback(boolean socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
    }

    @Generated
    public void setSocketFactoryPort(int socketFactoryPort) {
        this.socketFactoryPort = socketFactoryPort;
    }

    @Generated
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setCcs(String ccs) {
        this.ccs = ccs;
    }

    @Generated
    public void setBccs(String bccs) {
        this.bccs = bccs;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setAttachments(File[] attachments) {
        this.attachments = attachments;
    }

    @Generated
    public void setUseGlobalSession(boolean useGlobalSession) {
        this.useGlobalSession = useGlobalSession;
    }

    @Generated
    public GenericMaterial() {
    }

    @Generated
    public GenericMaterial(String host, Integer port, Boolean auth, String user, String pass, boolean debug, Charset charset, boolean splitlongparameters, boolean startttlsEnable, Boolean sslEnable, String socketFactoryClass, boolean socketFactoryFallback, int socketFactoryPort, long timeout, long connectionTimeout, String ccs, String bccs, String title, String content, File[] attachments, boolean useGlobalSession) {
        this.host = host;
        this.port = port;
        this.auth = auth;
        this.user = user;
        this.pass = pass;
        this.debug = debug;
        this.charset = charset;
        this.splitlongparameters = splitlongparameters;
        this.startttlsEnable = startttlsEnable;
        this.sslEnable = sslEnable;
        this.socketFactoryClass = socketFactoryClass;
        this.socketFactoryFallback = socketFactoryFallback;
        this.socketFactoryPort = socketFactoryPort;
        this.timeout = timeout;
        this.connectionTimeout = connectionTimeout;
        this.ccs = ccs;
        this.bccs = bccs;
        this.title = title;
        this.content = content;
        this.attachments = attachments;
        this.useGlobalSession = useGlobalSession;
    }

    @Generated
    public static abstract class GenericMaterialBuilder<C extends GenericMaterial, B extends GenericMaterialBuilder<C, B>>
    extends Material.MaterialBuilder<C, B> {
        @Generated
        private String host;
        @Generated
        private Integer port;
        @Generated
        private Boolean auth;
        @Generated
        private String user;
        @Generated
        private String pass;
        @Generated
        private boolean debug;
        @Generated
        private Charset charset;
        @Generated
        private boolean splitlongparameters;
        @Generated
        private boolean startttlsEnable;
        @Generated
        private Boolean sslEnable;
        @Generated
        private String socketFactoryClass;
        @Generated
        private boolean socketFactoryFallback;
        @Generated
        private int socketFactoryPort;
        @Generated
        private long timeout;
        @Generated
        private long connectionTimeout;
        @Generated
        private String ccs;
        @Generated
        private String bccs;
        @Generated
        private String title;
        @Generated
        private String content;
        @Generated
        private File[] attachments;
        @Generated
        private boolean useGlobalSession;

        @Generated
        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        @Generated
        public B port(Integer port) {
            this.port = port;
            return (B)this.self();
        }

        @Generated
        public B auth(Boolean auth) {
            this.auth = auth;
            return (B)this.self();
        }

        @Generated
        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        @Generated
        public B pass(String pass) {
            this.pass = pass;
            return (B)this.self();
        }

        @Generated
        public B debug(boolean debug) {
            this.debug = debug;
            return (B)this.self();
        }

        @Generated
        public B charset(Charset charset) {
            this.charset = charset;
            return (B)this.self();
        }

        @Generated
        public B splitlongparameters(boolean splitlongparameters) {
            this.splitlongparameters = splitlongparameters;
            return (B)this.self();
        }

        @Generated
        public B startttlsEnable(boolean startttlsEnable) {
            this.startttlsEnable = startttlsEnable;
            return (B)this.self();
        }

        @Generated
        public B sslEnable(Boolean sslEnable) {
            this.sslEnable = sslEnable;
            return (B)this.self();
        }

        @Generated
        public B socketFactoryClass(String socketFactoryClass) {
            this.socketFactoryClass = socketFactoryClass;
            return (B)this.self();
        }

        @Generated
        public B socketFactoryFallback(boolean socketFactoryFallback) {
            this.socketFactoryFallback = socketFactoryFallback;
            return (B)this.self();
        }

        @Generated
        public B socketFactoryPort(int socketFactoryPort) {
            this.socketFactoryPort = socketFactoryPort;
            return (B)this.self();
        }

        @Generated
        public B timeout(long timeout) {
            this.timeout = timeout;
            return (B)this.self();
        }

        @Generated
        public B connectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return (B)this.self();
        }

        @Generated
        public B ccs(String ccs) {
            this.ccs = ccs;
            return (B)this.self();
        }

        @Generated
        public B bccs(String bccs) {
            this.bccs = bccs;
            return (B)this.self();
        }

        @Generated
        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        @Override
        @Generated
        public B content(String content) {
            this.content = content;
            return (B)this.self();
        }

        @Generated
        public B attachments(File[] attachments) {
            this.attachments = attachments;
            return (B)this.self();
        }

        @Generated
        public B useGlobalSession(boolean useGlobalSession) {
            this.useGlobalSession = useGlobalSession;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GenericMaterial.GenericMaterialBuilder(super=" + super.toString() + ", host=" + this.host + ", port=" + this.port + ", auth=" + this.auth + ", user=" + this.user + ", pass=" + this.pass + ", debug=" + this.debug + ", charset=" + String.valueOf(this.charset) + ", splitlongparameters=" + this.splitlongparameters + ", startttlsEnable=" + this.startttlsEnable + ", sslEnable=" + this.sslEnable + ", socketFactoryClass=" + this.socketFactoryClass + ", socketFactoryFallback=" + this.socketFactoryFallback + ", socketFactoryPort=" + this.socketFactoryPort + ", timeout=" + this.timeout + ", connectionTimeout=" + this.connectionTimeout + ", ccs=" + this.ccs + ", bccs=" + this.bccs + ", title=" + this.title + ", content=" + this.content + ", attachments=" + Arrays.deepToString(this.attachments) + ", useGlobalSession=" + this.useGlobalSession + ")";
        }
    }

    @Generated
    private static final class GenericMaterialBuilderImpl
    extends GenericMaterialBuilder<GenericMaterial, GenericMaterialBuilderImpl> {
        @Generated
        private GenericMaterialBuilderImpl() {
        }

        @Override
        @Generated
        protected GenericMaterialBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GenericMaterial build() {
            return new GenericMaterial(this);
        }
    }
}

