/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.jpush;

import java.util.Base64;
import java.util.HashMap;
import java.util.Objects;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.AbstractProvider;
import org.miaixz.bus.notify.metric.jpush.JpushMaterial;

public class JpushSmsProvider
extends AbstractProvider<JpushMaterial, Context> {
    public JpushSmsProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(JpushMaterial entity) {
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("sign_id", entity.getSignature());
        bodys.put("mobile", entity.getReceive());
        bodys.put("temp_id", entity.getTemplate());
        bodys.put("temp_para", entity.getParams());
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Basic " + this.getSign());
        String response = Httpx.post((String)this.getUrl(entity), bodys, headers);
        boolean succeed = Objects.equals(JsonKit.getValue((String)response, (String)"success_count"), 0);
        String errcode = succeed ? ErrorCode.SUCCESS.getCode() : ErrorCode.FAILURE.getCode();
        String errmsg = succeed ? ErrorCode.SUCCESS.getDesc() : ErrorCode.FAILURE.getDesc();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }

    private String getSign() {
        String origin = this.context.getAppKey() + ":" + this.context.getAppSecret();
        return Base64.getEncoder().encodeToString(origin.getBytes(Charset.UTF_8));
    }
}

