/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.zhutong;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.crypto.Builder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.AbstractProvider;
import org.miaixz.bus.notify.metric.zhutong.ZhutongMaterial;

public class ZhutongSmsProvider
extends AbstractProvider<ZhutongMaterial, Context> {
    public ZhutongSmsProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(ZhutongMaterial entity) {
        if (ArrayKit.hasBlank((CharSequence[])new CharSequence[]{entity.getSignature(), entity.getTemplate(), entity.getTemplateName()})) {
            return this.sendForCustom(entity);
        }
        return this.sendForTemplate(entity);
    }

    protected Message sendForCustom(ZhutongMaterial entity) {
        String requestUrl = this.getUrl(entity);
        String username = this.context.getAppKey();
        String password = this.context.getAppSecret();
        this.validator(requestUrl, username, password);
        if (StringKit.isEmpty((CharSequence)entity.getReceive())) {
            throw new ValidateException("\u52a9\u901a\u77ed\u4fe1\uff1a\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (entity.getReceive().length() >= 20000) {
            throw new ValidateException("\u52a9\u901a\u77ed\u4fe1\uff1a\u624b\u673a\u53f7\u7801\u6700\u591a\u652f\u63012000\u4e2a\uff01");
        }
        if (StringKit.isBlank((CharSequence)entity.getContent())) {
            throw new ValidateException("\u52a9\u901a\u77ed\u4fe1\uff1a\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (entity.getContent().length() >= 1000) {
            throw new ValidateException("\u52a9\u901a\u77ed\u4fe1\uff1a\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc71000\u4e2a\u5b57\u7b26\uff01");
        }
        if (!entity.getContent().contains("\u3010")) {
            throw new ValidateException("\u52a9\u901a\u77ed\u4fe1\uff1a\u81ea\u5b9a\u4e49\u77ed\u4fe1\u53d1\u9001\u5185\u5bb9\u5fc5\u987b\u5305\u542b\u7b7e\u540d\u4fe1\u606f\uff0c\u5982\uff1a\u3010\u52a9\u901a\u79d1\u6280\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\u662f8888\uff01");
        }
        String url = this.getUrl(entity) + "v2/sendSms";
        long tKey = System.currentTimeMillis() / 1000L;
        HashMap<String, Object> bodys = new HashMap<String, Object>(5);
        bodys.put("username", username);
        bodys.put("password", Builder.md5((String)(Builder.md5((String)password) + tKey)));
        bodys.put("tKey", "" + tKey);
        bodys.put("mobile", entity.getReceive());
        bodys.put("content", entity.getContent());
        HashMap headers = MapKit.newHashMap((int)1, (boolean)true);
        headers.put("Content-Type", "application/json");
        String response = Httpx.post((String)url, bodys, (Map)headers);
        boolean succeed = Objects.equals(JsonKit.getValue((String)response, (String)"code"), 0);
        String errcode = succeed ? ErrorCode.SUCCESS.getCode() : ErrorCode.FAILURE.getCode();
        String errmsg = succeed ? ErrorCode.SUCCESS.getDesc() : ErrorCode.FAILURE.getDesc();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }

    protected Message sendForTemplate(ZhutongMaterial entity) {
        this.validator(this.getUrl(entity), this.context.getAppKey(), this.context.getAppSecret());
        if (StringKit.isBlank((CharSequence)entity.getSignature())) {
            throw new InternalException("\u52a9\u901a\u77ed\u4fe1\uff1a\u6a21\u677f\u77ed\u4fe1\u4e2d\u5df2\u62a5\u5907\u7684\u7b7e\u540dsignature\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringKit.isBlank((CharSequence)entity.getTemplate())) {
            throw new InternalException("\u52a9\u901a\u77ed\u4fe1\uff1a\u6a21\u677f\u77ed\u4fe1\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
        }
        String url = this.getUrl(entity) + "v2/sendSmsTp";
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("username", this.context.getAppKey());
        long tKey = System.currentTimeMillis() / 1000L;
        bodys.put("tKey", String.valueOf(tKey));
        bodys.put("password", Builder.md5((String)(Builder.md5((String)this.context.getAppSecret()) + tKey)));
        bodys.put("tpId", entity.getTemplate());
        bodys.put("signature", entity.getSignature());
        bodys.put("ext", "");
        bodys.put("extend", "");
        HashMap records = new HashMap();
        for (String mobile : StringKit.split((CharSequence)entity.getReceive(), (CharSequence)",")) {
            HashMap<String, String> record = new HashMap<String, String>();
            record.put("mobile", mobile);
            record.put("tpContent", entity.getContent());
            records.putAll(record);
        }
        bodys.put("records", JsonKit.toJsonString(records));
        HashMap headers = MapKit.newHashMap((int)1, (boolean)true);
        headers.put("Content-Type", "application/json");
        String response = Httpx.post((String)url, bodys, (Map)headers);
        boolean succeed = Objects.equals(JsonKit.getValue((String)response, (String)"code"), 0);
        String errcode = succeed ? ErrorCode.SUCCESS.getCode() : ErrorCode.FAILURE.getCode();
        String errmsg = succeed ? ErrorCode.SUCCESS.getDesc() : ErrorCode.FAILURE.getDesc();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }

    private void validator(String requestUrl, String username, String password) {
        if (StringKit.isBlank((CharSequence)requestUrl)) {
            throw new ValidateException("\u52a9\u901a\u77ed\u4fe1\uff1arequestUrl\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!requestUrl.endsWith("/")) {
            throw new ValidateException("\u52a9\u901a\u77ed\u4fe1\uff1arequestUrl\u5fc5\u987b\u4ee5'/'\u7ed3\u5c3e!");
        }
        if (ArrayKit.hasBlank((CharSequence[])new CharSequence[]{username, password})) {
            throw new ValidateException("\u52a9\u901a\u77ed\u4fe1\uff1a\u8d26\u53f7username\u3001\u5bc6\u7801password\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

