/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.ctyun;

import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.crypto.Builder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.AbstractProvider;
import org.miaixz.bus.notify.metric.ctyun.CtyunMaterial;

public class CtyunSmsProvider
extends AbstractProvider<CtyunMaterial, Context> {
    public CtyunSmsProvider(Context context) {
        super(context);
    }

    private static Map<String, String> signHeader(String body, String key, String secret) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(4);
        Date now = new Date();
        String signatureDate = DateKit.format((Date)now, (DateTimeFormatter)Formatter.PURE_DATE_FORMATTER);
        String signatureTime = DateKit.format((Date)now, (String)"yyyyMMdd'T'HHmmss'Z'");
        String uuid = UUID.randomUUID().toString();
        String calculateContentHash = Builder.sha256((String)body);
        byte[] kTime = Builder.hmacSha256((byte[])secret.getBytes()).digest(signatureTime.getBytes());
        byte[] kAk = Builder.hmacSha256((byte[])key.getBytes()).digest(kTime);
        byte[] kDate = Builder.hmacSha256((byte[])signatureDate.getBytes()).digest(kAk);
        String signatureStr = String.format("ctyun-eop-request-id:%s\neop-date:%s\n", uuid, signatureTime) + "\n\n" + calculateContentHash;
        String signature = Base64.encode((byte[])Builder.hmacSha256((byte[])signatureStr.getBytes(StandardCharsets.UTF_8)).digest(kDate));
        String signHeader = String.format("%s Headers=ctyun-eop-request-id;eop-date Signature=%s", key, signature);
        map.put("Content-Type", "application/json");
        map.put("ctyun-eop-request-id", uuid);
        map.put("Eop-date", signatureTime);
        map.put("Eop-Authorization", signHeader);
        return map;
    }

    @Override
    public Message send(CtyunMaterial entity) {
        HashMap<String, String> bodys = new HashMap<String, String>(5);
        bodys.put("action", entity.getAction());
        bodys.put("phoneNumber", entity.getReceive());
        bodys.put("signName", entity.getSignature());
        bodys.put("templateParam", entity.getParams());
        bodys.put("templateCode", entity.getTemplate());
        String response = Httpx.post((String)this.getUrl(entity), bodys, CtyunSmsProvider.signHeader(JsonKit.toJsonString(bodys), this.context.getAppKey(), this.context.getAppSecret()));
        String errcode = (String)JsonKit.getValue((String)response, (String)"errcode");
        return Message.builder().errcode("200".equals(errcode) ? ErrorCode._SUCCESS.getKey() : errcode).errmsg((String)JsonKit.getValue((String)response, (String)"errmsg")).build();
    }
}

