/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.dingtalk;

import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.AbstractProvider;
import org.miaixz.bus.notify.metric.dingtalk.DingTalkMaterial;

public class DingTalkProvider
extends AbstractProvider<DingTalkMaterial, Context> {
    private AtomicReference<String> accessToken = new AtomicReference();
    private long refreshTokenTime;
    private long tokenTimeOut = Duration.ofSeconds(7000L).toMillis();

    public DingTalkProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(DingTalkMaterial entity) {
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("access_token", entity.getToken());
        bodys.put("agent_id", entity.getAgentId());
        bodys.put("msg", entity.getMsg());
        if (StringKit.isNotBlank((CharSequence)entity.getUserIdList())) {
            bodys.put("userid_list", entity.getUserIdList());
        }
        if (StringKit.isNotBlank((CharSequence)entity.getDeptIdList())) {
            bodys.put("dept_id_list", entity.getDeptIdList());
        }
        bodys.put("to_all_user", String.valueOf(entity.isToAllUser()));
        String response = Httpx.post((String)this.getUrl(entity), bodys);
        String errcode = (String)JsonKit.getValue((String)response, (String)"errcode");
        return Message.builder().errcode(String.valueOf(200).equals(errcode) ? ErrorCode._SUCCESS.getKey() : errcode).errmsg((String)JsonKit.getValue((String)response, (String)"errmsg")).build();
    }

    private String getToken(String url) {
        if (System.currentTimeMillis() - this.refreshTokenTime > this.tokenTimeOut || null == this.accessToken.get()) {
            return this.requestToken(url);
        }
        return this.accessToken.get();
    }

    private String requestToken(String url) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("corpid", this.context.getAppKey());
        paramMap.put("corpsecret", this.context.getAppSecret());
        String response = Httpx.get((String)url, paramMap);
        String errcode = (String)JsonKit.getValue((String)response, (String)"errcode");
        if (String.valueOf(200).equals(errcode)) {
            String access_token = (String)JsonKit.getValue((String)response, (String)"access_token");
            this.refreshTokenTime = System.currentTimeMillis();
            this.accessToken.set(access_token);
            return access_token;
        }
        Logger.error((String)"\u83b7\u53d6\u9489\u9489token\u5931\u8d25\uff1a{}", (Object[])((Object[])JsonKit.getValue((String)response, (String)"errmsg")));
        return null;
    }

    @Generated
    public void setAccessToken(AtomicReference<String> accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public void setRefreshTokenTime(long refreshTokenTime) {
        this.refreshTokenTime = refreshTokenTime;
    }

    @Generated
    public void setTokenTimeOut(long tokenTimeOut) {
        this.tokenTimeOut = tokenTimeOut;
    }
}

