/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.notify.metric.huawei;

import java.security.MessageDigest;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.AbstractProvider;
import org.miaixz.bus.notify.metric.huawei.HuaweiMaterial;

public class HuaweiSmsProvider
extends AbstractProvider<HuaweiMaterial, Context> {
    public static final String SUCCESS_CODE = "000000";
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";

    public HuaweiSmsProvider(Context context) {
        super(context);
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                sb.append("0");
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    @Override
    public Message send(HuaweiMaterial entity) {
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("from", entity.getSender());
        bodys.put("to", entity.getReceive());
        bodys.put("templateId", entity.getTemplate());
        bodys.put("templateParas", entity.getParams());
        bodys.put("signature", entity.getSignature());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Authorization", AUTH_HEADER_VALUE);
        headers.put("X-WSSE", this.buildWsseHeader());
        String response = Httpx.post((String)this.getUrl(entity), bodys, headers);
        String errcode = (String)JsonKit.getValue((String)response, (String)"code");
        return Message.builder().errcode(SUCCESS_CODE.equals(errcode) ? ErrorCode._SUCCESS.getKey() : errcode).errmsg((String)JsonKit.getValue((String)response, (String)"description")).build();
    }

    private String buildWsseHeader() {
        try {
            String time = DateKit.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
            String nonce = UUID.randomUUID().toString().replace("-", "");
            String text = nonce + time + this.context.getAppSecret();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(text.getBytes(Charset.UTF_8));
            String hexDigest = HuaweiSmsProvider.byte2Hex(digest.digest());
            String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes());
            return String.format(WSSE_HEADER_FORMAT, this.context.getAppKey(), passwordDigestBase64Str, nonce, time);
        }
        catch (Exception e) {
            throw new InternalException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

