/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.Serialize;

public class Paginating<T>
extends Serialize<T> {
    public static final int DEFAULT_NAVIGATE_PAGES = 8;
    private int pageNo;
    private int pageSize;
    private int size;
    private long startRow;
    private long endRow;
    private int pages;
    private int prePage;
    private int nextPage;
    private boolean isFirstPage = false;
    private boolean isLastPage = false;
    private boolean hasPreviousPage = false;
    private boolean hasNextPage = false;
    private int navigatePages;
    private int[] navigatepageNo;
    private int navigateFirstPage;
    private int navigateLastPage;

    public Paginating() {
    }

    public Paginating(List<? extends T> list) {
        this(list, 8);
    }

    public Paginating(List<? extends T> list, int navigatePages) {
        super(list);
        if (list instanceof Page) {
            Page page = (Page)list;
            this.pageNo = page.getPageNo();
            this.pageSize = page.getPageSize();
            this.pages = page.getPages();
            this.size = page.size();
            if (this.size == 0) {
                this.startRow = 0L;
                this.endRow = 0L;
            } else {
                this.startRow = page.getStartRow() + 1L;
                this.endRow = this.startRow - 1L + (long)this.size;
            }
        } else if (list instanceof Collection) {
            this.pageNo = 1;
            this.pageSize = list.size();
            this.pages = this.pageSize > 0 ? 1 : 0;
            this.size = list.size();
            this.startRow = 0L;
            long l = this.endRow = list.size() > 0 ? (long)(list.size() - 1) : 0L;
        }
        if (list instanceof Collection) {
            this.calcByNavigatePages(navigatePages);
        }
    }

    public static <T> Paginating<T> of(List<? extends T> list) {
        return new Paginating<T>(list);
    }

    public static <T> Paginating<T> of(long total, List<? extends T> list) {
        if (list instanceof Page) {
            Page page = (Page)list;
            page.setTotal(total);
        }
        return new Paginating<T>(list);
    }

    public static <T> Paginating<T> of(List<? extends T> list, int navigatePages) {
        return new Paginating<T>(list, navigatePages);
    }

    public static <T> Paginating<T> emptyPageInfo() {
        return new Paginating(Collections.emptyList(), 0);
    }

    public void calcByNavigatePages(int navigatePages) {
        this.setNavigatePages(navigatePages);
        this.calcNavigatepageNo();
        this.calcPage();
        this.judgePageBoudary();
    }

    private void calcNavigatepageNo() {
        if (this.pages <= this.navigatePages) {
            this.navigatepageNo = new int[this.pages];
            for (int i = 0; i < this.pages; ++i) {
                this.navigatepageNo[i] = i + 1;
            }
        } else {
            this.navigatepageNo = new int[this.navigatePages];
            int startNum = this.pageNo - this.navigatePages / 2;
            int endNum = this.pageNo + this.navigatePages / 2;
            if (startNum < 1) {
                startNum = 1;
                for (int i = 0; i < this.navigatePages; ++i) {
                    this.navigatepageNo[i] = startNum++;
                }
            } else if (endNum > this.pages) {
                endNum = this.pages;
                for (int i = this.navigatePages - 1; i >= 0; --i) {
                    this.navigatepageNo[i] = endNum--;
                }
            } else {
                for (int i = 0; i < this.navigatePages; ++i) {
                    this.navigatepageNo[i] = startNum++;
                }
            }
        }
    }

    private void calcPage() {
        if (this.navigatepageNo != null && this.navigatepageNo.length > 0) {
            this.navigateFirstPage = this.navigatepageNo[0];
            this.navigateLastPage = this.navigatepageNo[this.navigatepageNo.length - 1];
            if (this.pageNo > 1) {
                this.prePage = this.pageNo - 1;
            }
            if (this.pageNo < this.pages) {
                this.nextPage = this.pageNo + 1;
            }
        }
    }

    private void judgePageBoudary() {
        this.isFirstPage = this.pageNo == 1;
        this.isLastPage = this.pageNo == this.pages || this.pages == 0;
        this.hasPreviousPage = this.pageNo > 1;
        this.hasNextPage = this.pageNo < this.pages;
    }

    public <E> Paginating<E> convert(Page.Function<T, E> function) {
        ArrayList<E> list = new ArrayList<E>(this.list.size());
        for (Object t : this.list) {
            list.add(function.apply(t));
        }
        Paginating newPaginating = new Paginating(list);
        newPaginating.setPageNo(this.pageNo);
        newPaginating.setPageSize(this.pageSize);
        newPaginating.setSize(this.size);
        newPaginating.setStartRow(this.startRow);
        newPaginating.setEndRow(this.endRow);
        newPaginating.setTotal(this.total);
        newPaginating.setPages(this.pages);
        newPaginating.setPrePage(this.prePage);
        newPaginating.setNextPage(this.nextPage);
        newPaginating.setIsFirstPage(this.isFirstPage);
        newPaginating.setIsLastPage(this.isLastPage);
        newPaginating.setHasPreviousPage(this.hasPreviousPage);
        newPaginating.setHasNextPage(this.hasNextPage);
        newPaginating.setNavigatePages(this.navigatePages);
        newPaginating.setNavigateFirstPage(this.navigateFirstPage);
        newPaginating.setNavigateLastPage(this.navigateLastPage);
        newPaginating.setNavigatepageNo(this.navigatepageNo);
        return newPaginating;
    }

    public boolean hasContent() {
        return this.size > 0;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getStartRow() {
        return this.startRow;
    }

    public void setStartRow(long startRow) {
        this.startRow = startRow;
    }

    public long getEndRow() {
        return this.endRow;
    }

    public void setEndRow(long endRow) {
        this.endRow = endRow;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public int getPrePage() {
        return this.prePage;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public boolean isIsFirstPage() {
        return this.isFirstPage;
    }

    public void setIsFirstPage(boolean isFirstPage) {
        this.isFirstPage = isFirstPage;
    }

    public boolean isIsLastPage() {
        return this.isLastPage;
    }

    public void setIsLastPage(boolean isLastPage) {
        this.isLastPage = isLastPage;
    }

    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public int getNavigatePages() {
        return this.navigatePages;
    }

    public void setNavigatePages(int navigatePages) {
        this.navigatePages = navigatePages;
    }

    public int[] getNavigatepageNo() {
        return this.navigatepageNo;
    }

    public void setNavigatepageNo(int[] navigatepageNo) {
        this.navigatepageNo = navigatepageNo;
    }

    public int getNavigateFirstPage() {
        return this.navigateFirstPage;
    }

    public void setNavigateFirstPage(int navigateFirstPage) {
        this.navigateFirstPage = navigateFirstPage;
    }

    public int getNavigateLastPage() {
        return this.navigateLastPage;
    }

    public void setNavigateLastPage(int navigateLastPage) {
        this.navigateLastPage = navigateLastPage;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Paginating{");
        sb.append("pageNo=").append(this.pageNo);
        sb.append(", pageSize=").append(this.pageSize);
        sb.append(", size=").append(this.size);
        sb.append(", startRow=").append(this.startRow);
        sb.append(", endRow=").append(this.endRow);
        sb.append(", total=").append(this.total);
        sb.append(", pages=").append(this.pages);
        sb.append(", list=").append(this.list);
        sb.append(", prePage=").append(this.prePage);
        sb.append(", nextPage=").append(this.nextPage);
        sb.append(", isFirstPage=").append(this.isFirstPage);
        sb.append(", isLastPage=").append(this.isLastPage);
        sb.append(", hasPreviousPage=").append(this.hasPreviousPage);
        sb.append(", hasNextPage=").append(this.hasNextPage);
        sb.append(", navigatePages=").append(this.navigatePages);
        sb.append(", navigateFirstPage=").append(this.navigateFirstPage);
        sb.append(", navigateLastPage=").append(this.navigateLastPage);
        sb.append(", navigatepageNo=");
        if (this.navigatepageNo == null) {
            sb.append("null");
        } else {
            sb.append('[');
            for (int i = 0; i < this.navigatepageNo.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.navigatepageNo[i]);
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }
}

