/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.builtin;

import java.util.Properties;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.Querying;
import org.miaixz.bus.pager.builtin.PageObject;

public abstract class PageMethod {
    protected static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();
    protected static boolean DEFAULT_COUNT = true;

    public static <T> Page<T> getLocalPage() {
        return LOCAL_PAGE.get();
    }

    public static void setLocalPage(Page page) {
        LOCAL_PAGE.set(page);
    }

    public static void clearPage() {
        LOCAL_PAGE.remove();
    }

    public static long count(Querying select) {
        Page page = PageMethod.startPage(1, -1, true).disableAsyncCount();
        select.doSelect();
        return page.getTotal();
    }

    public static <E> Page<E> startPage(Object params) {
        Page page = PageObject.getPageFromObject(params, true);
        Page oldPage = PageMethod.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        PageMethod.setLocalPage(page);
        return page;
    }

    public static <E> Page<E> startPage(int pageNo, int pageSize) {
        return PageMethod.startPage(pageNo, pageSize, DEFAULT_COUNT);
    }

    public static <E> Page<E> startPage(int pageNo, int pageSize, boolean count) {
        return PageMethod.startPage(pageNo, pageSize, count, null, null);
    }

    public static <E> Page<E> startPage(int pageNo, int pageSize, String orderBy) {
        Page<E> page = PageMethod.startPage(pageNo, pageSize);
        page.setOrderBy(orderBy);
        return page;
    }

    public static <E> Page<E> startPage(int pageNo, int pageSize, boolean count, Boolean reasonable, Boolean pageSizeZero) {
        Page page = new Page(pageNo, pageSize, count);
        page.setReasonable(reasonable);
        page.setPageSizeZero(pageSizeZero);
        Page oldPage = PageMethod.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        PageMethod.setLocalPage(page);
        return page;
    }

    public static <E> Page<E> offsetPage(int offset, int limit) {
        return PageMethod.offsetPage(offset, limit, DEFAULT_COUNT);
    }

    public static <E> Page<E> offsetPage(int offset, int limit, boolean count) {
        Page page = new Page(new int[]{offset, limit}, count);
        Page oldPage = PageMethod.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        PageMethod.setLocalPage(page);
        return page;
    }

    public static void orderBy(String orderBy) {
        Page<Object> page = PageMethod.getLocalPage();
        if (page != null) {
            page.setOrderBy(orderBy);
            if (page.getPageSizeZero() != null && page.getPageSizeZero().booleanValue() && page.getPageSize() == 0) {
                page.setOrderByOnly(true);
            }
        } else {
            page = new Page();
            page.setOrderBy(orderBy);
            page.setOrderByOnly(true);
            PageMethod.setLocalPage(page);
        }
    }

    protected static void setStaticProperties(Properties properties) {
        if (properties != null) {
            DEFAULT_COUNT = Boolean.valueOf(properties.getProperty("defaultCount", "true"));
        }
    }
}

