/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.builtin;

import java.util.Properties;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.PageContext;
import org.miaixz.bus.pager.Paging;
import org.miaixz.bus.pager.RowBounds;
import org.miaixz.bus.pager.builtin.PageObject;

public class PageParams {
    protected boolean offsetAsPageNo = false;
    protected boolean rowBoundsWithCount = false;
    protected boolean pageSizeZero = false;
    protected boolean reasonable = false;
    protected boolean supportMethodsArguments = false;
    protected String countColumn = "0";
    private boolean keepOrderBy = false;
    private boolean keepSubSelectOrderBy = false;
    private boolean asyncCount = false;

    public Page getPage(Object parameterObject, org.apache.ibatis.session.RowBounds rowBounds) {
        Page<Object> page = PageContext.getLocalPage();
        if (page == null) {
            if (rowBounds != org.apache.ibatis.session.RowBounds.DEFAULT) {
                if (this.offsetAsPageNo) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(new int[]{rowBounds.getOffset(), rowBounds.getLimit()}, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
                if (rowBounds instanceof RowBounds) {
                    RowBounds pageRowBounds = (RowBounds)rowBounds;
                    page.setCount(pageRowBounds.getCount() == null || pageRowBounds.getCount() != false);
                }
            } else if (parameterObject instanceof Paging || this.supportMethodsArguments) {
                try {
                    page = PageObject.getPageFromObject(parameterObject, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (page == null) {
                return null;
            }
            PageContext.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        if (page.getKeepOrderBy() == null) {
            page.setKeepOrderBy(this.keepOrderBy);
        }
        if (page.getKeepSubSelectOrderBy() == null) {
            page.setKeepSubSelectOrderBy(this.keepSubSelectOrderBy);
        }
        return page;
    }

    public void setProperties(Properties properties) {
        this.offsetAsPageNo = Boolean.parseBoolean(properties.getProperty("offsetAsPageNo"));
        String rowBoundsWithCount = properties.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = properties.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = properties.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        String supportMethodsArguments = properties.getProperty("supportMethodsArguments");
        this.supportMethodsArguments = Boolean.parseBoolean(supportMethodsArguments);
        String countColumn = properties.getProperty("countColumn");
        if (StringKit.isNotEmpty((CharSequence)countColumn)) {
            this.countColumn = countColumn;
        }
        PageObject.setParams(properties.getProperty("params"));
        this.keepOrderBy = Boolean.parseBoolean(properties.getProperty("keepOrderBy"));
        this.keepSubSelectOrderBy = Boolean.parseBoolean(properties.getProperty("keepSubSelectOrderBy"));
        this.asyncCount = Boolean.parseBoolean(properties.getProperty("asyncCount"));
    }

    public boolean isOffsetAsPageNo() {
        return this.offsetAsPageNo;
    }

    public boolean isRowBoundsWithCount() {
        return this.rowBoundsWithCount;
    }

    public boolean isPageSizeZero() {
        return this.pageSizeZero;
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public boolean isSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    public String getCountColumn() {
        return this.countColumn;
    }

    public boolean isAsyncCount() {
        return this.asyncCount;
    }
}

