/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.cache;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.miaixz.bus.core.lang.exception.PageException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.Property;
import org.miaixz.bus.pager.cache.Cache;
import org.miaixz.bus.pager.cache.GuavaCache;
import org.miaixz.bus.pager.cache.SimpleCache;

public abstract class CacheFactory {
    public static <K, V> Cache<K, V> createCache(String sqlCacheClass, String prefix, Properties properties) {
        if (StringKit.isEmpty((CharSequence)sqlCacheClass)) {
            try {
                Class.forName("com.google.common.cache.Cache");
                return new GuavaCache(properties, prefix);
            }
            catch (Throwable t) {
                return new SimpleCache(properties, prefix);
            }
        }
        try {
            Class<?> clazz = Class.forName(sqlCacheClass);
            try {
                Constructor<?> constructor = clazz.getConstructor(Properties.class, String.class);
                return (Cache)constructor.newInstance(properties, prefix);
            }
            catch (Exception e) {
                Cache cache = (Cache)clazz.newInstance();
                if (cache instanceof Property) {
                    ((Property)((Object)cache)).setProperties(properties);
                }
                return cache;
            }
        }
        catch (Throwable t) {
            throw new PageException("Created Sql Cache [" + sqlCacheClass + "] Error", t);
        }
    }
}

