/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.cache;

import com.google.common.cache.CacheBuilder;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.cache.Cache;

public class GuavaCache<K, V>
implements Cache<K, V> {
    private final com.google.common.cache.Cache<K, V> CACHE;

    public GuavaCache(Properties properties, String prefix) {
        String initialCapacity;
        String expireAfterWrite;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        String maximumSize = properties.getProperty(prefix + ".maximumSize");
        if (StringKit.isNotEmpty((CharSequence)maximumSize)) {
            cacheBuilder.maximumSize(Long.parseLong(maximumSize));
        } else {
            cacheBuilder.maximumSize(1000L);
        }
        String expireAfterAccess = properties.getProperty(prefix + ".expireAfterAccess");
        if (StringKit.isNotEmpty((CharSequence)expireAfterAccess)) {
            cacheBuilder.expireAfterAccess(Long.parseLong(expireAfterAccess), TimeUnit.MILLISECONDS);
        }
        if (StringKit.isNotEmpty((CharSequence)(expireAfterWrite = properties.getProperty(prefix + ".expireAfterWrite")))) {
            cacheBuilder.expireAfterWrite(Long.parseLong(expireAfterWrite), TimeUnit.MILLISECONDS);
        }
        if (StringKit.isNotEmpty((CharSequence)(initialCapacity = properties.getProperty(prefix + ".initialCapacity")))) {
            cacheBuilder.initialCapacity(Integer.parseInt(initialCapacity));
        }
        this.CACHE = cacheBuilder.build();
    }

    @Override
    public V get(K key) {
        return (V)this.CACHE.getIfPresent(key);
    }

    @Override
    public void put(K key, V value) {
        this.CACHE.put(key, value);
    }
}

