/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.dialect.auto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.miaixz.bus.pager.AutoDialect;
import org.miaixz.bus.pager.dialect.AbstractAutoDialect;
import org.miaixz.bus.pager.dialect.AbstractPaging;
import org.miaixz.bus.pager.dialect.auto.Druid;
import org.miaixz.bus.pager.dialect.auto.Early;
import org.miaixz.bus.pager.dialect.auto.Hikari;

public class Defalut
implements AutoDialect<String> {
    private static final List<AbstractAutoDialect> AUTO_DIALECTS = new ArrayList<AbstractAutoDialect>();
    private Map<String, AbstractAutoDialect> urlMap = new ConcurrentHashMap<String, AbstractAutoDialect>();

    public static void registerAutoDialect(AbstractAutoDialect autoDialect) {
        AUTO_DIALECTS.add(autoDialect);
    }

    @Override
    public String extractDialectKey(MappedStatement ms, DataSource dataSource, Properties properties) {
        for (AbstractAutoDialect autoDialect : AUTO_DIALECTS) {
            String dialectKey = autoDialect.extractDialectKey(ms, dataSource, properties);
            if (dialectKey == null) continue;
            if (!this.urlMap.containsKey(dialectKey)) {
                this.urlMap.put(dialectKey, autoDialect);
            }
            return dialectKey;
        }
        return Early.DEFAULT.extractDialectKey(ms, dataSource, properties);
    }

    @Override
    public AbstractPaging extractDialect(String dialectKey, MappedStatement ms, DataSource dataSource, Properties properties) {
        if (dialectKey != null && this.urlMap.containsKey(dialectKey)) {
            return this.urlMap.get(dialectKey).extractDialect(dialectKey, ms, dataSource, properties);
        }
        return Early.DEFAULT.extractDialect(dialectKey, ms, dataSource, properties);
    }

    static {
        try {
            AUTO_DIALECTS.add(new Hikari());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AUTO_DIALECTS.add(new Druid());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

